/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.IOUtil;
import org.mule.tools.maven.plugin.domain.AbstractMuleMojo;

public class MuleDomainInstallMojo
extends AbstractMuleMojo {
    protected boolean copyToDomainsDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.copyToDomainsDirectory || Boolean.getBoolean("mule.domain.copyToDomainsDirectory")) {
            File muleHome = this.determineMuleHome();
            if (muleHome != null) {
                this.copyMuleZipToMuleHome(muleHome);
            } else {
                this.getLog().warn((CharSequence)("MULE_HOME is not set, not copying " + this.finalName + ".zip"));
            }
        }
    }

    private File determineMuleHome() throws MojoExecutionException {
        File muleHomeFile = null;
        String muleHome = this.getMuleHomeEnvVarOrSystemProperty();
        if (muleHome != null) {
            muleHomeFile = new File(muleHome);
            if (!muleHomeFile.exists()) {
                String message = String.format("MULE_HOME is set to %1s but this directory does not exist.", muleHome);
                throw new MojoExecutionException(message);
            }
            if (!muleHomeFile.canWrite()) {
                String message = String.format("MULE_HOME is set to %1s but the directory is not writeable.", muleHome);
                throw new MojoExecutionException(message);
            }
        }
        return muleHomeFile;
    }

    private String getMuleHomeEnvVarOrSystemProperty() {
        String muleHome = System.getProperty("mule.home");
        if (muleHome == null) {
            muleHome = System.getenv("MULE_HOME");
        }
        return muleHome;
    }

    private void copyMuleZipToMuleHome(File muleHome) throws MojoExecutionException {
        try {
            this.copyMuleZipFileToTempFileInDomainsDirectory(muleHome);
            this.renameMuleZipFileToFinalName(muleHome);
        }
        catch (IOException iox) {
            throw new MojoExecutionException("Exception while copying to apps directory", (Exception)iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyMuleZipFileToTempFileInDomainsDirectory(File muleHome) throws IOException {
        FileInputStream muleZipInput = null;
        FileOutputStream tempOutput = null;
        try {
            File zipFile = this.getMuleZipFile();
            muleZipInput = new FileInputStream(zipFile);
            File tempFile = this.tempFileInDomainsDirectory(muleHome);
            tempOutput = new FileOutputStream(tempFile);
            IOUtil.copy((InputStream)muleZipInput, (OutputStream)tempOutput);
            String message = String.format("Copying %1s to %2s", zipFile.getAbsolutePath(), tempFile.getAbsolutePath());
            this.getLog().info((CharSequence)message);
        }
        catch (Throwable throwable) {
            IOUtil.close(muleZipInput);
            IOUtil.close(tempOutput);
            throw throwable;
        }
        IOUtil.close((InputStream)muleZipInput);
        IOUtil.close((OutputStream)tempOutput);
    }

    private void renameMuleZipFileToFinalName(File muleHome) throws MojoExecutionException {
        File domainsDirectory;
        File targetFile;
        File sourceFile = this.tempFileInDomainsDirectory(muleHome);
        if (!sourceFile.renameTo(targetFile = new File(domainsDirectory = this.muleDomainsDirectory(muleHome), this.finalName + ".zip"))) {
            String message = String.format("Could not rename %1s to %2s", sourceFile.getAbsolutePath(), targetFile.getAbsolutePath());
            throw new MojoExecutionException(message);
        }
        String message = String.format("Renaming %1s to %2s", sourceFile.getAbsolutePath(), targetFile.getAbsolutePath());
        this.getLog().info((CharSequence)message);
    }

    private File tempFileInDomainsDirectory(File muleHome) {
        File appsDirectory = this.muleDomainsDirectory(muleHome);
        return new File(appsDirectory, this.finalName + ".temp");
    }

    private File muleDomainsDirectory(File muleHome) {
        return new File(muleHome, "domains");
    }
}

