/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.domain;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.logging.Logger;
import org.mule.tools.maven.plugin.domain.AbstractMuleMojo;
import org.mule.tools.maven.plugin.domain.ArtifactFilter;
import org.mule.tools.maven.plugin.domain.Exclusion;
import org.mule.tools.maven.plugin.domain.Inclusion;
import org.mule.tools.maven.plugin.domain.MuleArchiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleDomainMojo
extends AbstractMuleMojo {
    private MavenProjectHelper projectHelper;
    private List<Exclusion> exclusions;
    private List<Inclusion> inclusions;
    private boolean excludeMuleDependencies;
    private boolean prependGroupId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File domain = this.getMuleZipFile();
        try {
            this.createMuleDomain(domain);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule App", (Exception)((Object)e));
        }
        this.projectHelper.attachArtifact(this.project, "zip", domain);
    }

    protected Logger createLogger() {
        return new Logger(){

            public void debug(String s) {
                MuleDomainMojo.this.getLog().debug((CharSequence)s);
            }

            public void debug(String s, Throwable throwable) {
                MuleDomainMojo.this.getLog().debug((CharSequence)s, throwable);
            }

            public boolean isDebugEnabled() {
                return MuleDomainMojo.this.getLog().isDebugEnabled();
            }

            public void info(String s) {
                MuleDomainMojo.this.getLog().info((CharSequence)s);
            }

            public void info(String s, Throwable throwable) {
                MuleDomainMojo.this.getLog().info((CharSequence)s, throwable);
            }

            public boolean isInfoEnabled() {
                return MuleDomainMojo.this.getLog().isInfoEnabled();
            }

            public void warn(String s) {
                MuleDomainMojo.this.getLog().warn((CharSequence)s);
            }

            public void warn(String s, Throwable throwable) {
                MuleDomainMojo.this.getLog().warn((CharSequence)s, throwable);
            }

            public boolean isWarnEnabled() {
                return MuleDomainMojo.this.getLog().isWarnEnabled();
            }

            public void error(String s) {
                MuleDomainMojo.this.getLog().error((CharSequence)s);
            }

            public void error(String s, Throwable throwable) {
                MuleDomainMojo.this.getLog().error((CharSequence)s, throwable);
            }

            public boolean isErrorEnabled() {
                return MuleDomainMojo.this.getLog().isErrorEnabled();
            }

            public void fatalError(String s) {
                MuleDomainMojo.this.getLog().error((CharSequence)s);
            }

            public void fatalError(String s, Throwable throwable) {
                MuleDomainMojo.this.getLog().error((CharSequence)s, throwable);
            }

            public boolean isFatalErrorEnabled() {
                return MuleDomainMojo.this.getLog().isErrorEnabled();
            }

            public Logger getChildLogger(String s) {
                return null;
            }

            public int getThreshold() {
                return 0;
            }

            public String getName() {
                return null;
            }
        };
    }

    protected void createMuleDomain(File domain) throws MojoExecutionException, ArchiverException {
        MuleArchiver archiver = new MuleArchiver(this.prependGroupId);
        this.addDependencies(archiver);
        this.addResourcesFile(archiver);
        this.addDomainFile(archiver);
        archiver.setDestFile(domain);
        try {
            domain.delete();
            archiver.createArchive();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot create archive", (Throwable)e);
        }
    }

    protected void addAppsZipFilesToArchive(ZipArchiver archiver, File appsFolder) throws MojoExecutionException {
        if (appsFolder.exists()) {
            File[] directories;
            for (File file : directories = appsFolder.listFiles()) {
                if (!file.isDirectory() || file.isHidden()) continue;
                File targetFolder = new File(file, "target");
                if (!targetFolder.exists()) {
                    throw new MojoExecutionException("Cannot bound app " + file.getName() + ". Seems it was not build");
                }
                File[] zipFiles = targetFolder.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".zip");
                    }
                });
                if (zipFiles.length == 0) {
                    throw new MojoExecutionException("No application zip in project " + file.getName());
                }
                File muleApp = zipFiles[0];
                try {
                    archiver.addFile(muleApp, "apps" + File.separator + muleApp.getName());
                }
                catch (ArchiverException e) {
                    throw new MojoExecutionException("Error adding domain application " + muleApp.getName(), (Exception)((Object)e));
                }
            }
        } else {
            throw new RuntimeException(appsFolder.getAbsolutePath() + " does not exists");
        }
    }

    private void addDomainFile(MuleArchiver archiver) throws ArchiverException {
        archiver.addResources(this.domainDirectory);
    }

    private void addResourcesFile(MuleArchiver archiver) throws ArchiverException {
        archiver.addResources(this.resourcesDirectory);
    }

    private void validateProject() throws MojoExecutionException {
        File muleConfig = new File(this.appDirectory, "mule-config.xml");
        File deploymentDescriptor = new File(this.appDirectory, "mule-deploy.properties");
        if (!muleConfig.exists() && !deploymentDescriptor.exists()) {
            String message = String.format("No mule-config.xml or mule-deploy.properties in %1s", this.project.getBasedir());
            this.getLog().error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
    }

    private void addDependencies(MuleArchiver archiver) throws ArchiverException {
        for (Artifact artifact : this.getArtifactsToArchive()) {
            String message = String.format("Adding <%1s> as a lib", artifact.getId());
            this.getLog().info((CharSequence)message);
            archiver.addLibraryArtifact(artifact);
        }
    }

    private Set<Artifact> getArtifactsToArchive() {
        ArtifactFilter filter = new ArtifactFilter(this.project, this.inclusions, this.exclusions, this.excludeMuleDependencies);
        return filter.getArtifactsToArchive();
    }
}

