/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.domain;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.mule.tools.maven.plugin.domain.MuleDomainMojo;

public class MuleDomainBundleMojo
extends MuleDomainMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        File targetDirectory = new File(this.project.getBuild().getDirectory());
        if (!targetDirectory.exists() && !targetDirectory.mkdir()) {
            throw new MojoExecutionException("Could not create target directory");
        }
        if (this.project.getParent() == null) {
            throw new MojoExecutionException("Mule maven plugin with bundleApps=true can't be used without a parent project aggregating domains and apps");
        }
        if (this.project.getParent().getModules() == null || this.project.getParent().getModules().size() < 3) {
            throw new MojoExecutionException("Verify your project structure. Seems that domain project, or apps project or domain-bundle project are missing");
        }
        String domainProjectFolder = (String)this.project.getParent().getModules().get(0);
        File domainProjectFolderFile = new File(this.project.getBasedir().getParentFile(), domainProjectFolder);
        if (!domainProjectFolderFile.exists()) {
            throw new MojoExecutionException(String.format("Folder for project %s does not exists", domainProjectFolder));
        }
        File domainProjectTargetFolderFile = new File(domainProjectFolderFile, "target");
        if (!domainProjectTargetFolderFile.exists()) {
            throw new MojoExecutionException(String.format("Folder target for project %s does not exists. Did you build %s project successfully?", domainProjectFolder, domainProjectTargetFolderFile.getAbsolutePath()));
        }
        File[] filesInTargetFolder = domainProjectTargetFolderFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".zip");
            }
        });
        if (filesInTargetFolder.length == 0) {
            throw new MojoExecutionException(String.format("Target folder %s does not contain a domain zip file", domainProjectFolder));
        }
        File domainZipFile = filesInTargetFolder[0];
        ZipUnArchiver domainUnzipArchiver = new ZipUnArchiver();
        File domainBundleTempDir = new File(this.project.getBasedir(), "target" + File.separator + "domain-bundle-temp");
        if (domainBundleTempDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)domainBundleTempDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not delete directory " + domainBundleTempDir.getAbsolutePath());
            }
        }
        if (!domainBundleTempDir.mkdir()) {
            throw new MojoExecutionException(String.format("Could not create folder %s", domainBundleTempDir));
        }
        try {
            domainUnzipArchiver.enableLogging(this.createLogger());
            domainUnzipArchiver.setSourceFile(domainZipFile);
            domainUnzipArchiver.setDestDirectory(domainBundleTempDir);
            domainUnzipArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Failure unzipping domain zip file", (Exception)((Object)e));
        }
        ZipArchiver muleArchiver = new ZipArchiver();
        try {
            muleArchiver.addDirectory(domainBundleTempDir);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Could not add domain temp directory to zip files", (Exception)((Object)e));
        }
        File appsModuleFolder = new File(this.project.getBasedir().getParent(), "apps");
        if (!appsModuleFolder.exists()) {
            throw new MojoExecutionException(String.format("Could not find apps module in %s", appsModuleFolder.getAbsolutePath()));
        }
        this.addAppsZipFilesToArchive(muleArchiver, appsModuleFolder);
        String extension = ".zip";
        File artifactFile = new File(targetDirectory, this.project.getBuild().getFinalName() + extension);
        this.project.getArtifact().setFile(artifactFile);
        muleArchiver.setDestFile(artifactFile);
        try {
            muleArchiver.createArchive();
            FileUtils.deleteDirectory((File)domainBundleTempDir);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not create domain bundle zip file", e);
        }
    }
}

