/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.mule.tools.maven.plugin.domain.AbstractMuleMojo;

public class ProcessResources
extends AbstractMuleMojo {
    public static final String META_INF_FOLDER = "META-INF";
    public static final String MULE_EXPORT_PROPERTIES_FILE = "mule_export.properties";
    public static final String MULE_EXPORT_VERSION_KEY = "mule_export_version";
    public static final String MULE_EXPORT_VERSION_VALUE = "2.0";
    public static final String MULE_EXPORTED_PROJECTS_KEY = "mule_exported_projects";
    public static final String[] BLACK_LIST = new String[]{".DS_STORE", "target"};
    private static final Set<String> BLACK_LIST_SET = new HashSet<String>(Arrays.asList(BLACK_LIST));
    private boolean attachMuleSources;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.attachMuleSources) {
            File projectBaseFolder = this.project.getBasedir();
            File targetFolder = new File(this.project.getBuild().getDirectory());
            String projectName = projectBaseFolder.getName();
            File metaInfFolder = new File(targetFolder, META_INF_FOLDER);
            metaInfFolder.mkdir();
            this.generateMuleExportProperties(metaInfFolder, projectName);
            this.generateExportedZipFile(metaInfFolder, projectBaseFolder);
        } else {
            this.getLog().info((CharSequence)"attachMuleSources default value is false, skipping process-resources goal...");
        }
    }

    private void generateExportedZipFile(File exportableFolder, File projectBaseFolder) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(exportableFolder.getAbsolutePath() + File.separator + projectBaseFolder.getName() + ".zip");
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            ProcessResources.zipFile(projectBaseFolder, projectBaseFolder.getName(), zipOut);
            zipOut.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateMuleExportProperties(File exportableFolder, String projectName) throws MojoExecutionException {
        try (FileOutputStream output = new FileOutputStream(new File(exportableFolder, MULE_EXPORT_PROPERTIES_FILE));){
            Properties muleExportProperties = new Properties();
            muleExportProperties.setProperty(MULE_EXPORT_VERSION_KEY, MULE_EXPORT_VERSION_VALUE);
            muleExportProperties.setProperty(MULE_EXPORTED_PROJECTS_KEY, projectName);
            muleExportProperties.store(output, null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create mule_export.properties", (Exception)e);
        }
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        if (!ProcessResources.isInBlackList(fileToZip)) {
            if (fileToZip.isDirectory()) {
                File[] children = fileToZip.listFiles();
                ZipEntry zipEntry = new ZipEntry(fileName + "/");
                zipOut.putNextEntry(zipEntry);
                for (File childFile : children) {
                    ProcessResources.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
                }
            } else {
                int length;
                FileInputStream fis = new FileInputStream(fileToZip);
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipOut.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zipOut.write(bytes, 0, length);
                }
                fis.close();
            }
        }
    }

    private static boolean isInBlackList(File fileToZip) {
        return BLACK_LIST_SET.contains(fileToZip.getName());
    }
}

