/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.api;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.tooling.api.ConfigurationException;
import org.mule.tooling.api.ExtensionModelLoader;
import org.mule.tooling.api.ExtensionModelLoaderFactory;

public class AstGenerator {
    AstXmlParser xmlParser;

    public AstGenerator(MavenClient mavenClient, String runtimeVersion, List<Dependency> dependencies, Path workingDir) {
        ClassLoader classloader = AstGenerator.class.getClassLoader();
        ExtensionModelLoader loader = ExtensionModelLoaderFactory.createLoader(mavenClient, workingDir, classloader, runtimeVersion);
        HashSet<ExtensionModel> extensionModels = new HashSet<ExtensionModel>();
        for (Dependency d : dependencies) {
            if (d.getClassifier() == null || !d.getClassifier().equals("mule-plugin")) continue;
            Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> extensionInformation = loader.load(AstGenerator.toBundleDescriptor(d));
            extensionInformation.forEach(item -> extensionModels.add((ExtensionModel)item.getSecond()));
        }
        Set<ExtensionModel> runtimeExtensionModels = loader.getRuntimeExtensionModels();
        extensionModels.addAll(runtimeExtensionModels);
        AstXmlParser.Builder builder = new AstXmlParser.Builder();
        builder.withExtensionModels(extensionModels);
        this.xmlParser = builder.build();
    }

    public static BundleDescriptor toBundleDescriptor(Dependency dependency) {
        return new BundleDescriptor.Builder().setGroupId(dependency.getGroupId()).setArtifactId(dependency.getArtifactId()).setVersion(dependency.getVersion()).setBaseVersion(dependency.getVersion()).setClassifier(dependency.getClassifier()).setType(dependency.getType()).build();
    }

    public ArtifactAst generateAST(List<String> configs, Path configsPath) throws FileNotFoundException {
        ArrayList<Pair> appXmlConfigInputStreams = new ArrayList<Pair>();
        for (String config : configs) {
            appXmlConfigInputStreams.add(new Pair((Object)config, (Object)new FileInputStream(configsPath.resolve(config).toFile())));
        }
        return appXmlConfigInputStreams.isEmpty() ? null : this.xmlParser.parse(appXmlConfigInputStreams);
    }

    public ArrayList<ValidationResultItem> validateAST(ArtifactAst artifactAst) throws ConfigurationException {
        ValidationResult result = MuleAstUtils.validate((ArtifactAst)artifactAst);
        ArrayList errors = new ArrayList();
        ArrayList<ValidationResultItem> warnings = new ArrayList<ValidationResultItem>();
        result.getItems().forEach(v -> {
            if (v.getValidation().getLevel().equals((Object)Validation.Level.ERROR)) {
                errors.add(v);
            } else {
                warnings.add((ValidationResultItem)v);
            }
        });
        if (errors.size() > 0) {
            throw new ConfigurationException(((ValidationResultItem)errors.get(0)).getMessage());
        }
        return warnings;
    }

    public static InputStream serialize(ArtifactAst artifactAst) {
        return new ArtifactAstSerializerProvider().getSerializer("JSON", "1.0").serialize(artifactAst);
    }
}

