/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule;

import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.maven.plugin.mule.AbstractApi;
import org.mule.tools.maven.plugin.mule.ApiException;
import org.mule.tools.maven.plugin.mule.arm.AuthorizationResponse;
import org.mule.tools.maven.plugin.mule.arm.Environment;
import org.mule.tools.maven.plugin.mule.arm.Environments;
import org.mule.tools.maven.plugin.mule.arm.UserInfo;

public abstract class AbstractMuleApi
extends AbstractApi {
    private static final String ME = "/accounts/api/me";
    private static final String URI = "https://anypoint.mulesoft.com";
    private static final String LOGIN = "/accounts/login";
    private static final String ENVIRONMENTS = "/accounts/api/organizations/%s/environments";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String ENV_ID_HEADER = "X-ANYPNT-ENV-ID";
    private static final String ORG_ID_HEADER = "X-ANYPNT-ORG-ID";
    private String username;
    private String password;
    private String environment;
    private String bearerToken;
    private String envId;
    private String orgId;

    public AbstractMuleApi(Log log, String username, String password, String environment) {
        super(log);
        this.username = username;
        this.password = password;
        this.environment = environment;
    }

    public void init() {
        this.bearerToken = this.getBearerToken(this.username, this.password);
        this.orgId = this.getOrgId();
        this.envId = this.findEnvironmentByName((String)this.environment).id;
    }

    private String getBearerToken(String username, String password) {
        Entity json = Entity.json((Object)("{\"username\": \"" + username + "\", \"password\": \"" + password + "\"}"));
        Response response = this.post(URI, LOGIN, json);
        this.validateStatusSuccess(response);
        AuthorizationResponse authorizationResponse = (AuthorizationResponse)response.readEntity(AuthorizationResponse.class);
        return authorizationResponse.access_token;
    }

    protected void validateStatusSuccess(Response response) {
        if (Response.Status.Family.familyOf((int)response.getStatus()) != Response.Status.Family.SUCCESSFUL) {
            throw new ApiException(response);
        }
    }

    public String getOrgId() {
        UserInfo response = this.get(URI, ME, UserInfo.class);
        return response.user.organization.id;
    }

    public Environment findEnvironmentByName(String name) {
        Environments response = this.get(URI, String.format(ENVIRONMENTS, this.orgId), Environments.class);
        for (int i = 0; i < response.data.length; ++i) {
            if (!name.equals(response.data[i].name)) continue;
            return response.data[i];
        }
        throw new RuntimeException("Couldn't find environment named [" + name + "]");
    }

    @Override
    protected void configureRequest(Invocation.Builder builder) {
        if (this.bearerToken != null) {
            builder.header(AUTHORIZATION_HEADER, (Object)("bearer " + this.bearerToken));
        }
        if (this.envId != null && this.orgId != null) {
            builder.header(ENV_ID_HEADER, (Object)this.envId);
            builder.header(ORG_ID_HEADER, (Object)this.orgId);
        }
    }
}

