/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.maven.plugin.mule.AbstractMuleMojo;
import org.mule.tools.maven.plugin.mule.Undeployer;
import org.mule.tools.maven.plugin.mule.agent.AgentApi;
import org.mule.tools.maven.plugin.mule.arm.Applications;
import org.mule.tools.maven.plugin.mule.arm.ArmApi;
import org.mule.tools.maven.plugin.mule.arm.Data;
import org.mule.tools.maven.plugin.mule.cloudhub.CloudhubApi;

@Mojo(name="undeploy", requiresProject=true)
public class UndeployMojo
extends AbstractMuleMojo {
    @Parameter(property="mule.home", required=false)
    private File muleHome;
    @Parameter(defaultValue="2", readonly=true, required=true)
    private Integer size;
    @Parameter(readonly=true, property="mule.version")
    private String muleVersion;
    @Parameter(required=false, readonly=true, property="anypoint.username")
    private String username;
    @Parameter(required=false, readonly=true, property="anypoint.password")
    private String password;
    @Parameter(required=true, readonly=true)
    private AbstractMuleMojo.DeploymentType deploymentType;
    @Parameter(readonly=true, property="anypoint.uri", defaultValue="https://anypoint.mulesoft.com")
    protected String uri;
    @Parameter(required=false, readonly=true, property="anypoint.environment")
    protected String environment;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        switch (this.deploymentType) {
            case standalone: {
                this.standalone();
                break;
            }
            case cluster: {
                this.cluster();
                break;
            }
            case arm: {
                this.arm();
                break;
            }
            case cloudhub: {
                this.cloudhub();
                break;
            }
            case agent: {
                this.agent();
                break;
            }
            default: {
                throw new MojoFailureException("Unsupported deployment type: " + (Object)((Object)this.deploymentType));
            }
        }
    }

    private void cloudhub() throws MojoFailureException {
        CloudhubApi cloudhubApi = new CloudhubApi(this.getLog(), this.username, this.password, this.environment);
        cloudhubApi.init();
        this.initializeApplication();
        this.getLog().info((CharSequence)("Stopping application " + this.applicationName));
        cloudhubApi.stopApplication(this.applicationName);
    }

    private void arm() throws MojoFailureException {
        ArmApi arm = new ArmApi(this.getLog(), this.uri, this.username, this.password, this.environment);
        arm.init();
        this.initializeApplication();
        Data app = this.findApplication(arm, this.applicationName);
        arm.undeployApplication(app.id);
    }

    private void agent() throws MojoFailureException {
        AgentApi agentApi = new AgentApi(this.getLog(), this.uri);
        this.initializeApplication();
        this.getLog().info((CharSequence)("Undeploying application " + this.applicationName));
        agentApi.undeployApplication(this.applicationName);
    }

    private Data findApplication(ArmApi arm, String applicationName) throws MojoFailureException {
        Applications apps = arm.getApplications();
        for (int i = 0; i < apps.data.length; ++i) {
            if (!apps.data[i].artifact.name.equals(applicationName)) continue;
            return apps.data[i];
        }
        throw new MojoFailureException("Couldn't find appliation [" + applicationName + "]");
    }

    private void cluster() throws MojoFailureException, MojoExecutionException {
        this.initializeApplication();
        File[] muleHomes = new File[this.size.intValue()];
        for (int i = 0; i < this.size; ++i) {
            File parentDir = new File(this.mavenProject.getBuild().getDirectory(), "mule" + i);
            muleHomes[i] = new File(parentDir, "mule-enterprise-standalone-" + this.muleVersion);
            if (muleHomes[i].exists()) continue;
            throw new MojoFailureException(muleHomes[i].getAbsolutePath() + "directory does not exist.");
        }
        new Undeployer(this.getLog(), this.applicationName, muleHomes).execute();
    }

    public void standalone() throws MojoFailureException, MojoExecutionException {
        this.initializeApplication();
        if (!this.muleHome.exists()) {
            throw new MojoFailureException("MULE_HOME directory does not exist.");
        }
        this.getLog().info((CharSequence)("Using MULE_HOME: " + this.muleHome));
        new Undeployer(this.getLog(), this.applicationName, this.muleHome).execute();
    }
}

