/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.test.infrastructure.process.AppDeploymentProbe;
import org.mule.test.infrastructure.process.MuleControllerException;
import org.mule.test.infrastructure.process.MuleProcessController;

public class Deployer {
    private MuleProcessController mule;
    private Log log;
    private File application;
    private Prober prober;
    private long timeout;
    private long pollingDelay;
    private String[] arguments;

    public Deployer(MuleProcessController mule, Log log, File application, long timeout, String[] arguments, long pollingDelay) {
        this.mule = mule;
        this.log = log;
        this.application = application;
        this.timeout = timeout;
        this.pollingDelay = pollingDelay;
        this.arguments = arguments;
        this.prober = new PollingProber(timeout, pollingDelay);
        log.debug((CharSequence)this.toString());
    }

    public String toString() {
        return String.format("Deployer with [Controller=%s, log=%s, application=%s, timeout=%d, pollingDelay=%d ]", this.mule, this.log, this.application, this.timeout, this.pollingDelay);
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        try {
            this.startMuleIfStopped();
            this.deployApplications();
            this.waitForDeployments();
        }
        catch (MuleControllerException e) {
            throw new MojoFailureException("Error deploying application: [" + this.application + "]: " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Unexpected error deploying application: [" + this.application + "]", (Exception)e);
        }
    }

    private void waitForDeployments() throws MojoFailureException {
        if (!this.application.exists()) {
            throw new MojoFailureException("Application does not exists: " + this.application);
        }
        this.log.debug((CharSequence)("Checking for application [" + this.application + "] to be deployed."));
        String app = this.getApplicationName(this.application);
        try {
            this.prober.check((Probe)AppDeploymentProbe.isDeployed((MuleProcessController)this.mule, (String)app));
        }
        catch (AssertionError e) {
            this.log.error((CharSequence)("Couldn't deploy application [" + app + "] after [" + this.timeout + "] miliseconds. Check Mule ESB log"));
            throw new MojoFailureException("Application deployment timeout.");
        }
    }

    private String getApplicationName(File application) {
        String name = application.getName();
        int extensionBeginning = name.lastIndexOf(46);
        return extensionBeginning == -1 ? name : name.substring(0, extensionBeginning);
    }

    private void deployApplications() throws MojoFailureException {
        this.log.info((CharSequence)("Deploying application [" + this.application + "]"));
        try {
            this.mule.deploy(this.application.getAbsolutePath());
        }
        catch (MuleControllerException e) {
            this.log.error((CharSequence)("Couldn't deploy application: " + this.application + ". Check Mule ESB logs"));
        }
    }

    private void startMuleIfStopped() {
        this.log.debug((CharSequence)"Checking if Mule ESB is running.");
        if (!this.mule.isRunning()) {
            try {
                this.log.info((CharSequence)"Starting Mule ESB");
                if (this.arguments == null) {
                    this.mule.start(new String[0]);
                } else {
                    this.mule.start(this.arguments);
                }
            }
            catch (MuleControllerException e) {
                this.log.error((CharSequence)"Couldn't start Mule ESB. Check Mule ESB logs");
            }
        }
    }

    public Deployer addLibraries(List<File> libs) {
        for (File file : libs) {
            this.mule.addLibrary(file);
            this.log.debug((CharSequence)String.format("Adding library %s...", file));
        }
        return this;
    }

    public Deployer addDomain(File domain) throws MojoFailureException {
        try {
            this.log.debug((CharSequence)String.format("Deploying domain : %s", domain));
            this.mule.deployDomain(domain.getAbsolutePath());
            return this;
        }
        catch (MuleControllerException e) {
            this.log.error((CharSequence)("Couldn't deploy domain: " + domain));
            throw new MojoFailureException("Couldn't deploy domain: " + domain);
        }
    }
}

