/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule.arm;

import java.io.File;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.logging.Log;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.mule.tools.maven.plugin.mule.AbstractMuleApi;
import org.mule.tools.maven.plugin.mule.TargetType;
import org.mule.tools.maven.plugin.mule.arm.Application;
import org.mule.tools.maven.plugin.mule.arm.Applications;
import org.mule.tools.maven.plugin.mule.arm.Data;
import org.mule.tools.maven.plugin.mule.arm.Target;
import org.mule.tools.maven.plugin.mule.arm.Targets;

public class ArmApi
extends AbstractMuleApi {
    private static final String APPLICATIONS = "/hybrid/api/v1/applications";
    private static final String SERVERS = "/hybrid/api/v1/servers";
    private static final String SERVER_GROUPS = "/hybrid/api/v1/serverGroups";
    private static final String CLUSTERS = "/hybrid/api/v1/clusters";
    private boolean armInsecure;

    public ArmApi(Log log, String uri, String username, String password, String environment, String businessGroup, boolean armInsecure) {
        super(uri, log, username, password, environment, businessGroup);
        this.armInsecure = armInsecure;
        if (armInsecure) {
            log.warn((CharSequence)"Using insecure mode for connecting to ARM, please consider configuring your truststore with ARM certificates. This option is insecure and not intended for production use.");
        }
    }

    public Boolean isStarted(int applicationId) {
        Application application = this.getApplicationStatus(applicationId);
        return "STARTED".equals(application.data.lastReportedStatus);
    }

    public Application getApplicationStatus(int applicationId) {
        return this.get(this.uri, "/hybrid/api/v1/applications/" + applicationId, Application.class);
    }

    public String undeployApplication(int applicationId) {
        Response response = this.delete(this.uri, "/hybrid/api/v1/applications/" + applicationId);
        this.validateStatusSuccess(response);
        return (String)response.readEntity(String.class);
    }

    public String undeployApplication(String appName, TargetType targetType, String target) {
        Integer applicationId = this.findApplication(appName, targetType, target);
        if (applicationId == null) {
            String appNotFoundMessage = "Application %s does not exist on %s %s.";
            throw new NotFoundException(String.format(appNotFoundMessage, appName, targetType.toString(), target));
        }
        return this.undeployApplication(applicationId);
    }

    public Application deployApplication(File app, String appName, TargetType targetType, String target) {
        MultiPart body = this.buildRequestBody(app, appName, targetType, target);
        Response response = this.post(this.uri, APPLICATIONS, Entity.entity((Object)body, (MediaType)body.getMediaType()));
        this.validateStatusSuccess(response);
        return (Application)response.readEntity(Application.class);
    }

    public Application redeployApplication(int applicationId, File app, String appName, TargetType targetType, String target) {
        MultiPart body = this.buildRequestBody(app, appName, targetType, target);
        Response response = this.patch(this.uri, "/hybrid/api/v1/applications/" + applicationId, Entity.entity((Object)body, (MediaType)body.getMediaType()));
        this.validateStatusSuccess(response);
        return (Application)response.readEntity(Application.class);
    }

    private MultiPart buildRequestBody(File app, String appName, TargetType targetType, String target) {
        String id = this.getId(targetType, target);
        FileDataBodyPart applicationPart = new FileDataBodyPart("file", app);
        MultiPart body = new FormDataMultiPart().field("artifactName", appName).field("targetId", id).bodyPart((BodyPart)applicationPart);
        return body;
    }

    private String getId(TargetType targetType, String target) {
        String id = null;
        switch (targetType) {
            case server: {
                id = this.findServerByName((String)target).id;
                break;
            }
            case serverGroup: {
                id = this.findServerGroupByName((String)target).id;
                break;
            }
            case cluster: {
                id = this.findClusterByName((String)target).id;
            }
        }
        return id;
    }

    public Applications getApplications() {
        return this.get(this.uri, APPLICATIONS, Applications.class);
    }

    public Target findServerByName(String name) {
        return this.findTargetByName(name, SERVERS);
    }

    public Target findServerGroupByName(String name) {
        return this.findTargetByName(name, SERVER_GROUPS);
    }

    public Target findClusterByName(String name) {
        return this.findTargetByName(name, CLUSTERS);
    }

    private Target findTargetByName(String name, String path) {
        Targets response = this.get(this.uri, path, Targets.class);
        if (response.data == null) {
            throw new RuntimeException("Couldn't find target named [" + name + "]");
        }
        for (int i = 0; i < response.data.length; ++i) {
            if (!name.equals(response.data[i].name)) continue;
            return response.data[i];
        }
        throw new RuntimeException("Couldn't find target named [" + name + "]");
    }

    public Integer findApplication(String name, TargetType targetType, String target) {
        Applications apps = this.getApplications();
        Data[] appArray = this.getApplications().data;
        if (appArray == null) {
            return null;
        }
        String targetId = this.getId(targetType, target);
        for (int i = 0; i < appArray.length; ++i) {
            if (!name.equals(appArray[i].artifact.name) || !targetId.equals(appArray[i].target.id)) continue;
            return appArray[i].id;
        }
        return null;
    }

    @Override
    protected void configureSecurityContext(ClientBuilder builder) {
        if (this.armInsecure) {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, new TrustManager[]{new TrustAllManager()}, new SecureRandom());
                builder.hostnameVerifier((HostnameVerifier)new DummyHostnameVerifier()).sslContext(sslcontext);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class DummyHostnameVerifier
    implements HostnameVerifier {
        private DummyHostnameVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }
}

