/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.validation.project.AbstractProjectValidator;
import org.mule.tools.api.validation.project.ProjectValidatorFactory;
import org.mule.tools.model.agent.AgentDeployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.model.standalone.ClusterDeployment;
import org.mule.tools.model.standalone.StandaloneDeployment;

public abstract class AbstractGenericMojo
extends AbstractMojo {
    @Parameter
    protected CloudHubDeployment cloudHubDeployment;
    @Parameter
    protected ArmDeployment armDeployment;
    @Parameter
    protected StandaloneDeployment standaloneDeployment;
    @Parameter
    protected AgentDeployment agentDeployment;
    @Parameter
    protected ClusterDeployment clusterDeployment;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;
    @Parameter(readonly=true, required=true, defaultValue="${session}")
    protected MavenSession session;
    @Parameter(property="project", required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.basedir}")
    protected File projectBaseFolder;
    @Parameter(defaultValue="${projectBuildDirectory}")
    protected String projectBuildDirectory;
    @Parameter(alias="appName", property="appName", defaultValue="${project.build.finalName}")
    protected String finalName;
    @Parameter
    protected String classifier;
    protected AbstractProjectValidator validator;
    private ProjectInformation projectInformation;

    public abstract String getPreviousRunPlaceholder();

    public abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public void setCloudHubDeployment(CloudHubDeployment cloudHubDeployment) {
        this.cloudHubDeployment = cloudHubDeployment;
    }

    public void setArmDeployment(ArmDeployment armDeployment) {
        this.armDeployment = armDeployment;
    }

    public void setStandaloneDeployment(StandaloneDeployment standaloneDeployment) {
        this.standaloneDeployment = standaloneDeployment;
    }

    public void setAgentDeployment(AgentDeployment agentDeployment) {
        this.agentDeployment = agentDeployment;
    }

    public void setClusterDeployment(ClusterDeployment clusterDeployment) {
        this.clusterDeployment = clusterDeployment;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public AbstractProjectValidator getProjectValidator() {
        if (this.validator == null) {
            this.validator = ProjectValidatorFactory.create((ProjectInformation)this.getAndSetProjectInformation());
        }
        return this.validator;
    }

    protected ProjectInformation getAndSetProjectInformation() {
        ProjectInformation.Builder builder = new ProjectInformation.Builder();
        if (this.projectInformation == null) {
            boolean isDeployment = false;
            for (String goal : this.session.getGoals()) {
                isDeployment = isDeployment || StringUtils.equals((CharSequence)goal, (CharSequence)"deploy");
            }
            builder.withGroupId(this.project.getGroupId()).withArtifactId(this.project.getArtifactId()).withVersion(this.project.getVersion()).withPackaging(this.project.getPackaging()).withProjectBaseFolder(Paths.get(this.projectBaseFolder.toURI())).withBuildDirectory(Paths.get(this.project.getBuild().getDirectory(), new String[0])).isDeployment(isDeployment);
            if (isDeployment) {
                builder.withDeployments(Arrays.asList(this.agentDeployment, this.standaloneDeployment, this.armDeployment, this.cloudHubDeployment, this.clusterDeployment));
            }
            this.projectInformation = builder.build();
        }
        return this.projectInformation;
    }

    protected boolean hasExecutedBefore() {
        Map pluginContext = this.getPluginContext();
        if (pluginContext.containsKey(this.getPreviousRunPlaceholder())) {
            return true;
        }
        this.getPluginContext().put(this.getPreviousRunPlaceholder(), this.getPreviousRunPlaceholder());
        return false;
    }

    protected PackagingType getPackagingType() {
        return PackagingType.fromString((String)this.project.getPackaging());
    }

    public String getClassifier() {
        return this.getPackagingType().resolveClassifier(this.classifier);
    }
}

