/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.api.packager.resources.MuleResourcesGenerator;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.utils.DefaultArtifact;
import org.mule.tools.maven.utils.DefaultExclusion;
import org.mule.tools.maven.utils.DefaultInclusion;

@Mojo(name="process-resources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ProcessResourcesMojo
extends AbstractMuleMojo {
    @Parameter
    private List<DefaultExclusion> exclusions;
    @Parameter
    private List<DefaultInclusion> inclusions;
    @Parameter(defaultValue="true")
    private boolean excludeMuleDependencies;
    @Parameter(defaultValue="${attachMuleSources}")
    private boolean attachMuleSources = false;
    @Parameter(defaultValue="false", property="prependGroupId")
    private boolean prependGroupId;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getResourcesContentGenerator().generate(this.prependGroupId);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new MojoFailureException("Fail to generate resources", (Throwable)e);
        }
    }

    public MuleResourcesGenerator getResourcesContentGenerator() {
        HashSet<DefaultArtifact> projectArtifacts = new HashSet<DefaultArtifact>();
        for (Artifact artifact : this.project.getArtifacts()) {
            projectArtifacts.add(new DefaultArtifact(artifact));
        }
        return new MuleResourcesGenerator(projectArtifacts, this.exclusions, this.inclusions, this.excludeMuleDependencies, this.getAndSetProjectInformation(), this.attachMuleSources);
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_GENERATE_RESOURCES_PREVIOUS_RUN_PLACEHOLDER";
    }
}

