/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.maven.mojo.model.PackagingType;

public class Validator {
    private Path projectBaseDir;

    public Validator(Path projectBaseDir) {
        this.projectBaseDir = projectBaseDir;
    }

    public Boolean isProjectValid(String packagingType) throws ValidationException {
        this.isPackagingTypeValid(packagingType);
        this.isProjectStructureValid(packagingType);
        this.isDescriptorFilePresent(packagingType);
        return true;
    }

    public Boolean isPackagingTypeValid(String packagingType) throws ValidationException {
        try {
            PackagingType.fromString(packagingType);
        }
        catch (IllegalArgumentException e) {
            List packagingTypeNames = Arrays.stream(PackagingType.values()).map(type -> type.toString()).collect(Collectors.toList());
            throw new ValidationException("Unknown packaging type " + packagingType + ". Please specify a valid mule packaging type: " + String.join((CharSequence)", ", packagingTypeNames));
        }
        return true;
    }

    public Boolean isProjectStructureValid(String packagingType) throws ValidationException {
        File mainSrcApplication = this.mainSrcApplication(packagingType);
        if (!mainSrcApplication.exists()) {
            throw new ValidationException("The folder " + mainSrcApplication.getAbsolutePath() + " is mandatory");
        }
        return true;
    }

    public Boolean isDescriptorFilePresent(String packagingType) throws ValidationException {
        String fileName = PackagingType.fromString(packagingType).getDescriptorFileName();
        String errorMessage = "Invalid Mule project. Missing %s file, it must be present in the root of application";
        if (!this.projectBaseDir.resolve(fileName).toFile().exists()) {
            throw new ValidationException(String.format(errorMessage, fileName));
        }
        return true;
    }

    private File mainSrcApplication(String packagingType) throws ValidationException {
        return PackagingType.fromString(packagingType).getSourceFolderLocation(this.projectBaseDir).toFile();
    }
}

