/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.arm;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.client.AbstractDeployer;
import org.mule.tools.client.arm.ArmClient;
import org.mule.tools.client.exception.ClientException;
import org.mule.tools.client.model.TargetType;
import org.mule.tools.client.standalone.exception.DeploymentException;

public class ArmDeployer
extends AbstractDeployer {
    private final TargetType targetType;
    private final String target;
    private final ArmClient armClient;

    public ArmDeployer(String uri, String username, String password, String environment, TargetType targetType, String target, File application, String applicationName, Log log, String businessGroup, boolean armInsecure) {
        super(applicationName, application, log);
        this.targetType = targetType;
        this.target = target;
        this.armClient = new ArmClient(log, uri, username, password, environment, businessGroup, armInsecure);
    }

    @Override
    public void deploy() throws DeploymentException {
        try {
            this.armClient.init();
            Integer applicationId = this.armClient.findApplication(this.getApplicationName(), this.targetType, this.target);
            if (applicationId == null) {
                this.info("Deploying application " + this.getApplicationName());
                this.armClient.deployApplication(this.getApplicationFile(), this.getApplicationName(), this.targetType, this.target);
            } else {
                String alreadyExistsMessage = "Found application %s on %s %s. Redeploying application...";
                this.info(String.format(alreadyExistsMessage, this.getApplicationName(), this.targetType.toString(), this.target));
                this.armClient.redeployApplication(applicationId, this.getApplicationFile(), this.getApplicationName(), this.targetType, this.target);
            }
        }
        catch (ClientException e) {
            this.error("Failed: " + e.getMessage());
            throw new DeploymentException("Failed to deploy application " + this.getApplicationName(), e);
        }
    }
}

