/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.cloudhub;

import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.client.AbstractDeployer;
import org.mule.tools.client.cloudhub.Application;
import org.mule.tools.client.cloudhub.CloudhubClient;
import org.mule.tools.client.exception.ClientException;
import org.mule.tools.client.standalone.exception.DeploymentException;

public class CloudhubDeployer
extends AbstractDeployer {
    private final CloudhubClient cloudhubClient;
    private final String region;
    private final String muleVersion;
    private final Integer workers;
    private final String workerType;
    private final Map<String, String> properties;

    public CloudhubDeployer(String uri, String username, String password, String environment, String applicationName, File application, String region, String muleVersion, Integer workers, String workerType, Log log, Map<String, String> properties, String businessGroup) {
        super(applicationName, application, log);
        this.cloudhubClient = new CloudhubClient(uri, log, username, password, environment, businessGroup);
        this.region = region;
        this.muleVersion = muleVersion;
        this.workers = workers;
        this.workerType = workerType;
        this.properties = properties;
    }

    @Override
    public void deploy() throws DeploymentException {
        this.cloudhubClient.init();
        this.info("Deploying application " + this.getApplicationName() + " to Cloudhub");
        if (!this.getApplicationFile().exists()) {
            throw new DeploymentException("Application file " + this.getApplicationFile() + " does not exist.");
        }
        try {
            boolean domainAvailable = this.cloudhubClient.isNameAvailable(this.getApplicationName());
            if (domainAvailable) {
                this.info("Creating application " + this.getApplicationName());
                this.cloudhubClient.createApplication(this.getApplicationName(), this.region, this.muleVersion, this.workers, this.workerType, this.properties);
            } else {
                Application app = this.findApplicationFromCurrentUser(this.getApplicationName());
                if (app != null) {
                    this.info("Application " + this.getApplicationName() + " already exists, redeploying");
                    String updateRegion = this.region == null ? app.region : this.region;
                    String updateMuleVersion = this.muleVersion == null ? app.muleVersion : this.muleVersion;
                    Integer updateWorkers = this.workers == null ? app.workers : this.workers;
                    String updateWorkerType = this.workerType == null ? app.workerType : this.workerType;
                    this.cloudhubClient.updateApplication(this.getApplicationName(), updateRegion, updateMuleVersion, updateWorkers, updateWorkerType, this.properties);
                } else {
                    this.error("Domain " + this.getApplicationName() + " is not available. Aborting.");
                    throw new DeploymentException("Domain " + this.getApplicationName() + " is not available. Aborting.");
                }
            }
            this.info("Uploading application contents " + this.getApplicationName());
            this.cloudhubClient.uploadFile(this.getApplicationName(), this.getApplicationFile());
            this.info("Starting application " + this.getApplicationName());
            this.cloudhubClient.startApplication(this.getApplicationName());
        }
        catch (ClientException e) {
            this.error("Failed: " + e.getMessage());
            throw new DeploymentException("Failed to deploy application " + this.getApplicationName(), e);
        }
    }

    private Application findApplicationFromCurrentUser(String appName) {
        for (Application app : this.cloudhubClient.getApplications()) {
            if (!appName.equals(app.domain)) continue;
            return app;
        }
        return null;
    }
}

