/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.api.ContentGenerator;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.mojo.model.PackagingType;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateSourcesMojo
extends AbstractMuleMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        long start = System.currentTimeMillis();
        this.getLog().debug((CharSequence)"Generating source code...");
        try {
            this.getContentGenerator().createContent();
        }
        catch (IOException | IllegalArgumentException e) {
            throw new MojoFailureException("Fail to generate sources", (Throwable)e);
        }
        this.getLog().debug((CharSequence)MessageFormat.format("Source code generation done ({0}ms)", System.currentTimeMillis() - start));
    }

    protected ContentGenerator getContentGenerator() {
        return new ContentGenerator(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), PackagingType.fromString(this.project.getPackaging()), Paths.get(this.projectBaseFolder.toURI()), Paths.get(this.project.getBuild().getDirectory(), new String[0]));
    }
}

