/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.text.MessageFormat;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.api.Validator;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.maven.dependency.MulePluginsCompatibilityValidator;
import org.mule.tools.maven.dependency.resolver.MulePluginResolver;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
public class ValidateMojo
extends AbstractMuleMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skipValidation) {
            long start = System.currentTimeMillis();
            this.getLog().debug((CharSequence)"Validating Mule application...");
            try {
                this.getValidator().isProjectValid(this.project.getPackaging());
            }
            catch (ValidationException e) {
                throw new MojoExecutionException("Validation exception", (Exception)e);
            }
            this.validateMulePluginDependencies();
            this.validateSharedLibraries();
            this.getLog().debug((CharSequence)MessageFormat.format("Validation for Mule application done ({0}ms)", System.currentTimeMillis() - start));
        } else {
            this.getLog().debug((CharSequence)"Skipping Validation for Mule application");
        }
    }

    protected void validateSharedLibraries() throws MojoExecutionException {
        Set sharedLibrariesCoordinates;
        Set projectDependenciesCoordinates;
        if (this.sharedLibraries != null && this.sharedLibraries.size() != 0 && !(projectDependenciesCoordinates = this.project.getDependencies().stream().map(dependency -> dependency.getArtifactId() + ":" + dependency.getGroupId()).collect(Collectors.toSet())).containsAll(sharedLibrariesCoordinates = this.sharedLibraries.stream().map(dependency -> dependency.getArtifactId() + ":" + dependency.getGroupId()).collect(Collectors.toSet()))) {
            sharedLibrariesCoordinates.removeAll(projectDependenciesCoordinates);
            throw new MojoExecutionException("The mule application does not contain the following shared libraries: " + sharedLibrariesCoordinates.toString());
        }
    }

    protected void validateMulePluginDependencies() throws MojoExecutionException {
        this.getMulePluginsCompatibilityValidator().validate(this.getResolver().resolveMulePlugins(this.project));
    }

    protected Validator getValidator() {
        return new Validator(this.projectBaseFolder.toPath());
    }

    protected MulePluginResolver getResolver() {
        return new MulePluginResolver(this.getLog(), this.session, this.projectBuilder, this.repositorySystem, this.localRepository, this.remoteArtifactRepositories);
    }

    protected MulePluginsCompatibilityValidator getMulePluginsCompatibilityValidator() {
        return new MulePluginsCompatibilityValidator();
    }
}

