/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.repository;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.RemoteRepository;
import org.mule.maven.client.api.BundleDescriptorCreationException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.Authentication;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.maven.client.internal.AetherMavenClientProvider;
import org.mule.maven.client.internal.DefaultLocalRepositorySupplierFactory;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.mule.tools.maven.repository.MavenProjectBuilder;

public class ArtifactLocator {
    private static final String POM = "pom";
    private final List<RemoteRepository> remoteRepositories;
    private final Log log;
    private MavenProject project;
    private ArtifactRepository localRepository;
    private MavenProjectBuilder mavenProjectBuilder;
    private Set<Artifact> artifacts;

    public ArtifactLocator(List<RemoteRepository> remoteRepositories, MavenProject project, ArtifactRepository localRepository, MavenProjectBuilder mavenProjectBuilder, Log log) {
        this.remoteRepositories = remoteRepositories;
        this.project = project;
        this.localRepository = localRepository;
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.log = log;
        this.artifacts = new HashSet<Artifact>();
    }

    public Set<Artifact> getArtifacts(File pomFile, File targetFolder) throws MojoExecutionException {
        AetherMavenClient client = (AetherMavenClient)this.buildMavenClient();
        List dependencies = client.resolveApplicationBundleDependencies(pomFile, targetFolder);
        dependencies.forEach(dependency -> this.artifacts.add(this.buildArtifact((BundleDependency)dependency)));
        for (Artifact dep : new ArrayList<Artifact>(this.artifacts)) {
            this.addThirdPartyParentPomArtifacts(this.artifacts, dep);
        }
        this.addParentPomArtifacts(this.artifacts);
        return new HashSet<Artifact>(this.artifacts);
    }

    private Artifact buildArtifact(BundleDependency dependency) {
        BundleDescriptor descriptor = dependency.getDescriptor();
        DefaultArtifact artifact = new DefaultArtifact(descriptor.getGroupId(), descriptor.getArtifactId(), descriptor.getVersion(), null, descriptor.getType(), (String)descriptor.getClassifier().orElse(null), (ArtifactHandler)new DefaultArtifactHandler());
        artifact.setFile(new File(dependency.getBundleUri().getPath()));
        return artifact;
    }

    protected MavenClient buildMavenClient() {
        MavenConfiguration mavenConfiguration = this.buildMavenConfiguration();
        AetherMavenClientProvider provider = new AetherMavenClientProvider();
        return provider.createMavenClient(mavenConfiguration);
    }

    public MavenConfiguration buildMavenConfiguration() {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = new MavenConfiguration.MavenConfigurationBuilder();
        DefaultSettingsSupplierFactory settingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        Optional globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        globalSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).withGlobalSettingsLocation(arg_0));
        userSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).withUserSettingsLocation(arg_0));
        DefaultLocalRepositorySupplierFactory localRepositorySupplierFactory = new DefaultLocalRepositorySupplierFactory();
        Supplier localMavenRepository = localRepositorySupplierFactory.environmentMavenRepositorySupplier();
        this.remoteRepositories.stream().map(this::toRemoteRepo).forEach(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).withRemoteRepository(arg_0));
        return mavenConfigurationBuilder.withLocalMavenRepositoryLocation((File)localMavenRepository.get()).build();
    }

    private org.mule.maven.client.api.model.RemoteRepository toRemoteRepo(RemoteRepository remoteRepository) {
        String id = remoteRepository.getId();
        Optional<Authentication> authentication = this.getAuthentication(remoteRepository);
        URL url = null;
        try {
            url = this.getURL(remoteRepository);
        }
        catch (MavenExecutionException e) {
            e.printStackTrace();
        }
        RemoteRepository.RemoteRepositoryBuilder builder = new RemoteRepository.RemoteRepositoryBuilder();
        authentication.ifPresent(arg_0 -> ((RemoteRepository.RemoteRepositoryBuilder)builder).withAuthentication(arg_0));
        return builder.withId(id).withUrl(url).build();
    }

    private URL getURL(RemoteRepository remoteRepository) throws MavenExecutionException {
        try {
            return new URL(remoteRepository.getUrl());
        }
        catch (MalformedURLException e) {
            throw new MavenExecutionException(e.getMessage(), e.getCause());
        }
    }

    private Optional<Authentication> getAuthentication(RemoteRepository remoteRepository) {
        AuthenticationContext authenticationContext = AuthenticationContext.forRepository((RepositorySystemSession)new DefaultRepositorySystemSession(), (RemoteRepository)remoteRepository);
        if (authenticationContext == null) {
            return Optional.empty();
        }
        String password = new String((char[])authenticationContext.get("password", char[].class));
        String username = new String((char[])authenticationContext.get("username", char[].class));
        Authentication.AuthenticationBuilder authenticationBuilder = new Authentication.AuthenticationBuilder();
        AuthenticationContext.close((AuthenticationContext)authenticationContext);
        return Optional.of(authenticationBuilder.withPassword(password).withUsername(username).build());
    }

    private static Model createPomModel(File pomFile) {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (FileReader mulePluginPomFilerReader = new FileReader(pomFile);){
            model = reader.read((Reader)mulePluginPomFilerReader);
        }
        catch (IOException | XmlPullParserException e) {
            throw new BundleDescriptorCreationException(String.format("There was an issue reading '%s' in '%s'", pomFile.getName(), pomFile.getParentFile().getAbsolutePath()), e);
        }
        return model;
    }

    protected void addParentPomArtifacts(Set<Artifact> artifacts) throws MojoExecutionException {
        MavenProject currentProject = this.project;
        boolean projectParent = true;
        while (currentProject.hasParent() && projectParent) {
            if ((currentProject = currentProject.getParent()).getFile() == null) {
                projectParent = false;
                continue;
            }
            Artifact pomArtifact = currentProject.getArtifact();
            pomArtifact.setFile(currentProject.getFile());
            this.validatePomArtifactFile(pomArtifact);
            if (artifacts.add(pomArtifact)) continue;
            break;
        }
        if (!projectParent) {
            Artifact unresolvedParentPomArtifact = currentProject.getArtifact();
            this.addThirdPartyParentPomArtifacts(artifacts, unresolvedParentPomArtifact);
        }
    }

    protected void validatePomArtifactFile(Artifact resolvedPomArtifact) throws MojoExecutionException {
        if (resolvedPomArtifact.getFile() == null) {
            throw new MojoExecutionException(String.format("There was a problem trying to resolve the artifact's file location for [%s], file was null", resolvedPomArtifact.toString()));
        }
        if (!resolvedPomArtifact.getFile().exists()) {
            throw new MojoExecutionException(String.format("There was a problem trying to resolve the artifact's file location for [%s], file [%s] doesn't exist", resolvedPomArtifact.toString(), resolvedPomArtifact.getFile().getAbsolutePath()));
        }
    }

    protected void addThirdPartyParentPomArtifacts(Set<Artifact> artifacts, Artifact dep) throws MojoExecutionException {
        MavenProject project = this.mavenProjectBuilder.buildProjectFromArtifact(dep);
        this.addParentDependencyPomArtifacts(project, artifacts);
        Artifact pomArtifact = this.mavenProjectBuilder.createProjectArtifact(dep);
        artifacts.add(this.getResolvedArtifactUsingLocalRepository(pomArtifact));
    }

    protected Artifact getResolvedArtifactUsingLocalRepository(Artifact pomArtifact) throws MojoExecutionException {
        Artifact resolvedPomArtifact = this.localRepository.find(pomArtifact);
        this.validatePomArtifactFile(resolvedPomArtifact);
        return resolvedPomArtifact;
    }

    protected void addParentDependencyPomArtifacts(MavenProject projectDependency, Set<Artifact> artifacts) throws MojoExecutionException {
        Artifact pomArtifact;
        MavenProject currentProject = projectDependency;
        while (currentProject.hasParent() && artifacts.add(this.getResolvedArtifactUsingLocalRepository(pomArtifact = (currentProject = currentProject.getParent()).getArtifact()))) {
        }
    }

    public Set<Artifact> getExclusions() throws MojoExecutionException {
        HashSet<Artifact> exclusions = new HashSet<Artifact>();
        List directDependencies = this.project.getDependencies();
        Map directDependenciesCoordinates = directDependencies.stream().collect(Collectors.toMap(this::getCoordinates, Function.identity()));
        for (Artifact artifact : this.project.getArtifacts()) {
            Dependency dependency;
            if (!directDependenciesCoordinates.containsKey(artifact.toString()) || (dependency = (Dependency)directDependenciesCoordinates.get(artifact.toString())).getExclusions() == null || dependency.getExclusions().size() <= 0) continue;
            MavenProject artifactProject = this.mavenProjectBuilder.buildProjectFromArtifact(artifact);
            exclusions.addAll(this.findExcludedArtifacts(artifactProject, dependency.getExclusions()));
        }
        return new HashSet<Artifact>(exclusions);
    }

    private Set<Artifact> findExcludedArtifacts(MavenProject project, List<Exclusion> exclusions) {
        HashSet<Artifact> excludedArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : project.getArtifacts()) {
            for (Exclusion exclusion : exclusions) {
                if (!exclusion.getArtifactId().equals(artifact.getArtifactId()) || !exclusion.getGroupId().equals(artifact.getGroupId())) continue;
                excludedArtifacts.add(artifact);
            }
        }
        for (Dependency dependency : project.getDependencies()) {
            for (Exclusion exclusion : exclusions) {
                if (!exclusion.getArtifactId().equals(dependency.getArtifactId()) || !exclusion.getGroupId().equals(dependency.getGroupId())) continue;
                excludedArtifacts.add(this.createArtifact(dependency));
            }
        }
        excludedArtifacts.removeAll(this.artifacts);
        return excludedArtifacts;
    }

    private Artifact createArtifact(Dependency dependency) {
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType(), dependency.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler(dependency.getType()));
    }

    private String getCoordinates(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getType() + ":" + dependency.getVersion() + ":" + dependency.getScope();
    }
}

