/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.repository;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;

public class MavenProjectBuilder {
    private final RepositorySystem repositorySystem;
    private final Log log;
    private final ProjectBuilder projectBuilder;
    private final ProjectBuildingRequest projectBuildingRequest;

    public MavenProjectBuilder(ProjectBuilder projectBuilder, ProjectBuildingRequest projectBuildingRequest, RepositorySystem repositorySystem, Log log) {
        this.projectBuilder = projectBuilder;
        this.projectBuildingRequest = projectBuildingRequest;
        this.repositorySystem = repositorySystem;
        this.log = log;
    }

    public MavenProject buildProjectFromArtifact(Artifact artifact) throws MojoExecutionException {
        MavenProject mavenProject;
        Artifact projectArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        try {
            mavenProject = this.projectBuilder.build(projectArtifact, this.projectBuildingRequest).getProject();
        }
        catch (ProjectBuildingException e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((CharSequence)String.format("The artifact [%s] had the following issue ", artifact.toString()), (Throwable)e);
            }
            if (e.getResults() == null || e.getResults().size() != 1) {
                throw new MojoExecutionException(String.format("There was an issue while trying to create a maven project from the artifact [%s]", artifact.toString()), (Exception)((Object)e));
            }
            ProjectBuildingResult projectBuildingResult = (ProjectBuildingResult)e.getResults().get(0);
            List collect = projectBuildingResult.getProblems().stream().filter(modelProblem -> modelProblem.getSeverity().equals((Object)ModelProblem.Severity.FATAL)).collect(Collectors.toList());
            if (!collect.isEmpty()) {
                throw new MojoExecutionException(String.format("There was an issue while trying to create a maven project from the artifact [%s], several FATAL errors were found", artifact.toString()), (Exception)((Object)e));
            }
            mavenProject = projectBuildingResult.getProject();
        }
        return mavenProject;
    }

    public Artifact createProjectArtifact(Artifact dep) {
        return this.repositorySystem.createProjectArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
    }
}

