/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.resolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.mule.tools.maven.repository.MavenProjectBuilder;

public class ExcludedDependenciesResolver {
    private final MavenProjectBuilder mavenProjectBuilder;
    private final DependencyTreeBuilder treeBuilder;
    private final ArtifactRepository localRepository;
    private final ArtifactFactory artifactFactory;
    private final ArtifactMetadataSource artifactMetadataSource;
    private final ArtifactCollector artifactCollector;
    protected final Map<String, Artifact> excludedArtifacts;
    private final ArtifactFilter artifactFilter;

    public ExcludedDependenciesResolver(DependencyTreeBuilder treeBuilder, ArtifactRepository localRepository, ArtifactFactory artifactFactory, ArtifactMetadataSource artifactMetadataSource, ArtifactCollector artifactCollector, MavenProjectBuilder mavenProjectBuilder) {
        this.treeBuilder = treeBuilder;
        this.localRepository = localRepository;
        this.artifactFactory = artifactFactory;
        this.artifactMetadataSource = artifactMetadataSource;
        this.artifactCollector = artifactCollector;
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.excludedArtifacts = new HashMap<String, Artifact>();
        this.artifactFilter = new ScopeArtifactFilter(null);
    }

    public Set<Artifact> resolve(MavenProject project, Set<String> exclusions) throws MojoExecutionException, DependencyTreeBuilderException {
        DependencyNode rootNode = this.getProjectTreeRoot(project);
        this.resolveExclusionsVersions(rootNode, exclusions);
        return new HashSet<Artifact>(this.excludedArtifacts.values());
    }

    public void resolveExclusionsVersions(DependencyNode root, Set<String> exclusions) throws DependencyTreeBuilderException, MojoExecutionException {
        List<DependencyNode> originalDependenciesNodes = this.resolveOriginalDependencies(root);
        for (DependencyNode dependencyNode : originalDependenciesNodes) {
            this.findExclusionsInTree(dependencyNode, exclusions);
        }
    }

    protected List<DependencyNode> resolveOriginalDependencies(DependencyNode root) {
        CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
        root.accept((DependencyNodeVisitor)visitor);
        return visitor.getNodes();
    }

    protected void findExclusionsInTree(DependencyNode dependencyNode, Set<String> exclusions) throws MojoExecutionException, DependencyTreeBuilderException {
        DefaultArtifact artifact = (DefaultArtifact)dependencyNode.getArtifact();
        artifact.setDependencyFilter((ArtifactFilter)new EmptyFilter());
        MavenProject project = this.mavenProjectBuilder.buildProjectFromArtifact((Artifact)artifact);
        DependencyNode resolvedRoot = this.getProjectTreeRoot(project);
        this.findExclusionVersionByDepthSearch(resolvedRoot, exclusions);
    }

    protected void findExclusionVersionByDepthSearch(DependencyNode node, Set<String> exclusions) throws MojoExecutionException {
        DefaultArtifact currentArtifact = (DefaultArtifact)node.getArtifact();
        String exclusionCoordinates = currentArtifact.getGroupId() + ":" + currentArtifact.getArtifactId();
        if (this.shouldStopTraversing(exclusions, exclusionCoordinates)) {
            this.excludedArtifacts.put(exclusionCoordinates, this.excludedArtifacts.getOrDefault(exclusionCoordinates, (Artifact)currentArtifact));
            return;
        }
        for (Object child : node.getChildren()) {
            this.findExclusionVersionByDepthSearch((DependencyNode)child, exclusions);
        }
    }

    protected boolean shouldStopTraversing(Set<String> exclusions, String exclusionCoordinates) {
        return exclusions.contains(exclusionCoordinates);
    }

    private DependencyNode getProjectTreeRoot(MavenProject project) throws DependencyTreeBuilderException {
        return this.treeBuilder.buildDependencyTree(project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, this.artifactFilter, this.artifactCollector);
    }

    private class EmptyFilter
    implements ArtifactFilter {
        private EmptyFilter() {
        }

        public boolean include(Artifact artifact) {
            return true;
        }
    }
}

