/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.maven.project.MavenProject;

public class ProjectBaseFolderFileCloner {
    private Path sourceFilePath;
    private MavenProject project;
    private File projectBaseFolder;

    public ProjectBaseFolderFileCloner(MavenProject project) {
        this.project = project;
        this.projectBaseFolder = project.getBasedir();
    }

    public ProjectBaseFolderFileCloner clone(String descriptorName) throws IOException {
        this.sourceFilePath = new File(this.projectBaseFolder.getCanonicalPath() + File.separator + descriptorName).toPath();
        return this;
    }

    public void toPath(String ... destinationPath) throws IOException {
        File targetFolder = Paths.get(this.project.getBuild().getDirectory(), destinationPath).toFile();
        Path targetFilePath = new File(targetFolder.toPath().toString(), this.sourceFilePath.toFile().getName()).toPath();
        Files.copy(this.sourceFilePath, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
    }
}

