/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.dependency.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;

public class MulePluginResolver {
    private Log log;
    private MavenSession session;
    private ProjectBuilder projectBuilder;
    private RepositorySystem repositorySystem;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteArtifactRepositories;
    private ProjectBuildingRequest projectBuildingRequest;

    public MulePluginResolver(Log log, MavenSession session, ProjectBuilder projectBuilder, RepositorySystem repositorySystem, ArtifactRepository localRepository, List<ArtifactRepository> remoteArtifactRepositories) {
        this.log = log;
        this.session = session;
        this.projectBuilder = projectBuilder;
        this.repositorySystem = repositorySystem;
        this.localRepository = localRepository;
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.initialize();
    }

    public List<Dependency> resolveMulePlugins(MavenProject project) throws MojoExecutionException {
        ArrayList<Dependency> mulePlugins = new ArrayList<Dependency>();
        List directMulePluginDependencies = project.getDependencies().stream().filter(d -> d.getType().equals("jar")).filter(d -> d.getScope().equals("compile")).filter(d -> d.getClassifier() != null && d.getClassifier().equals("mule-plugin")).collect(Collectors.toList());
        mulePlugins.addAll(directMulePluginDependencies);
        for (Dependency d2 : directMulePluginDependencies) {
            mulePlugins.addAll(this.getAllMulePluginDependencies(this.buildMavenProject(d2.getGroupId(), d2.getArtifactId(), d2.getVersion())));
        }
        return mulePlugins;
    }

    private List<Dependency> getAllMulePluginDependencies(MavenProject project) throws MojoExecutionException {
        List mulePluginDependencies = project.getDependencies().stream().filter(d -> d.getType().equals("jar")).filter(d -> d.getScope().equals("provided")).filter(d -> d.getClassifier() != null && d.getClassifier().equals("mule-plugin")).collect(Collectors.toList());
        ArrayList<Dependency> effectiveMulePluginDependencies = new ArrayList<Dependency>(mulePluginDependencies);
        for (Dependency d2 : mulePluginDependencies) {
            MavenProject mavenProject = this.buildMavenProject(d2.getGroupId(), d2.getArtifactId(), d2.getVersion());
            effectiveMulePluginDependencies.addAll(this.getAllMulePluginDependencies(mavenProject));
        }
        return effectiveMulePluginDependencies;
    }

    private void initialize() {
        this.projectBuildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        this.projectBuildingRequest.setLocalRepository(this.localRepository);
        this.projectBuildingRequest.setRemoteRepositories(this.remoteArtifactRepositories);
        this.projectBuildingRequest.setResolveDependencies(true);
        this.log.debug((CharSequence)String.format("Local repository [%s]", this.projectBuildingRequest.getLocalRepository().getBasedir()));
        for (ArtifactRepository artifactRepository : this.projectBuildingRequest.getRemoteRepositories()) {
            this.log.debug((CharSequence)String.format("Remote repository ID [%s], URL [%s]", artifactRepository.getId(), artifactRepository.getUrl()));
        }
    }

    private MavenProject buildMavenProject(String groupId, String artifactId, String version) throws MojoExecutionException {
        Artifact projectArtifact = this.repositorySystem.createProjectArtifact(groupId, artifactId, version);
        return this.buildMavenProjectFromArtifact(projectArtifact);
    }

    private MavenProject buildMavenProjectFromArtifact(Artifact artifact) throws MojoExecutionException {
        MavenProject mavenProject;
        try {
            Artifact projectArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            mavenProject = this.projectBuilder.build(projectArtifact, this.projectBuildingRequest).getProject();
        }
        catch (ProjectBuildingException e) {
            this.log.warn((CharSequence)String.format("The artifact [%s] seems to have some warnings", artifact.toString()));
            this.log.debug((CharSequence)String.format("The artifact [%s] had the following issue ", artifact.toString()), (Throwable)e);
            mavenProject = this.buildMavenMavenProjectWithErrors(artifact, e);
        }
        return mavenProject;
    }

    private MavenProject buildMavenMavenProjectWithErrors(Artifact artifact, ProjectBuildingException e) throws MojoExecutionException {
        if (e.getResults() == null || e.getResults().size() != 1) {
            throw new MojoExecutionException(String.format("There was an issue while trying to create a maven project from the artifact [%s]", artifact.toString()), (Exception)((Object)e));
        }
        ProjectBuildingResult projectBuildingResult = (ProjectBuildingResult)e.getResults().get(0);
        List fatalProblems = projectBuildingResult.getProblems().stream().filter(modelProblem -> modelProblem.getSeverity().equals((Object)ModelProblem.Severity.FATAL)).collect(Collectors.toList());
        if (!fatalProblems.isEmpty()) {
            throw new MojoExecutionException(String.format("There was an issue while trying to create a maven project from the artifact [%s], several FATAL errors were found", artifact.toString()), (Exception)((Object)e));
        }
        return projectBuildingResult.getProject();
    }
}

