/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.dependency;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.mule.tools.maven.dependency.DependencyMapBuilder;

public class MulePluginsCompatibilityValidator {
    private final DependencyMapBuilder dependencyMapBuilder = new DependencyMapBuilder();

    public void validate(List<Dependency> mulePlugins) throws MojoExecutionException {
        for (Map.Entry<String, List<Dependency>> entry : this.dependencyMapBuilder.build(mulePlugins).entrySet()) {
            if (entry.getValue().size() <= 1 || this.areMulePluginVersionCompatible(entry.getValue())) continue;
            StringBuilder message = new StringBuilder().append("There are incompatible versions of the same mule plugin in the application dependency graph.").append("This application can not be package as it will fail to deploy.").append("Offending mule plugin: ").append(entry.getKey()).append("Versions: ");
            entry.getValue().forEach(d -> message.append(d.getVersion()).append(","));
            throw new MojoExecutionException(message.toString());
        }
    }

    private boolean areMulePluginVersionCompatible(List<Dependency> dependencies) {
        Set majors = dependencies.stream().map(d -> d.getVersion()).map(v -> v.substring(0, v.indexOf("."))).collect(Collectors.toSet());
        return majors.size() <= 1;
    }
}

