/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.ProjectBuildingException;
import org.mule.tools.maven.dependency.ApplicationDependencySelector;
import org.mule.tools.maven.dependency.resolver.MulePluginResolver;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.util.CopyFileVisitor;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateSourcesMojo
extends AbstractMuleMojo {
    private static final String MULE_MODULE_GROUP_ID = "org.mule.modules";
    protected MulePluginResolver mulePluginResolver;
    protected ApplicationDependencySelector applicationDependencySelector;
    private final Set<String> containerPlugins = new HashSet<String>();

    public GenerateSourcesMojo() {
        this.containerPlugins.add("org.mule.modules:mule-module-http-ext");
        this.containerPlugins.add("org.mule.modules:mule-module-extensions-xml-support");
        this.containerPlugins.add("org.mule.modules:mule-module-sockets");
        this.containerPlugins.add("org.mule.modules:mule-module-oauth");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Creating target content with Mule source code...");
        try {
            this.createLibFolderContent();
            this.createMuleFolderContent();
            this.createPluginsFolderContent();
            this.createDescriptorFilesContent();
            this.createMuleSourceFolderContent();
        }
        catch (IOException | ProjectBuildingException e) {
            throw new MojoFailureException("Fail to generate sources", e);
        }
    }

    protected void createMuleFolderContent() throws IOException {
        File targetFolder = Paths.get(this.project.getBuild().getDirectory(), "mule").toFile();
        Files.walkFileTree(this.muleSourceFolder.toPath(), new CopyFileVisitor(this.muleSourceFolder, targetFolder));
    }

    protected void createLibFolderContent() throws IOException {
        this.addJarsFromProjectCompileDependencies();
        this.addJarsFromProjectLibFolder();
    }

    protected void addJarsFromProjectCompileDependencies() throws IOException {
        List dependencies = this.project.getArtifacts().stream().filter(d -> d.getType().equals("jar")).filter(d -> d.getScope().equals("compile")).filter(d -> d.getClassifier() == null || !d.getClassifier().equals("mule-plugin")).collect(Collectors.toList());
        for (File f : dependencies.stream().map(a -> a.getFile()).collect(Collectors.toList())) {
            File targetFolder = Paths.get(this.project.getBuild().getDirectory(), "lib").toFile();
            Path sourceFilePath = f.toPath();
            Path targetFilePath = new File(targetFolder.toPath().toString() + File.separator + f.getName()).toPath();
            Files.copy(sourceFilePath, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected void addJarsFromProjectLibFolder() throws IOException {
        File targetFolder = Paths.get(this.project.getBuild().getDirectory(), "lib").toFile();
        Files.walkFileTree(this.libFolder.toPath(), new CopyFileVisitor(this.libFolder, targetFolder));
    }

    protected void createPluginsFolderContent() throws IOException, MojoExecutionException, ProjectBuildingException {
        this.initializeResolver();
        this.initializeApplicationDependencySelector();
        List<Dependency> mulePluginDependencies = this.mulePluginResolver.resolveMulePlugins(this.project);
        List<Dependency> selectedMulePlugins = this.applicationDependencySelector.select(mulePluginDependencies);
        List selectedMulePluginFiles = selectedMulePlugins.stream().filter(mulePlugin -> this.isNotAlreadyPresentInMuleContainer((Dependency)mulePlugin)).map(smp -> this.localRepository.find(this.repositorySystem.createDependencyArtifact(smp)).getFile()).collect(Collectors.toList());
        for (File f : selectedMulePluginFiles) {
            File targetFolder = Paths.get(this.project.getBuild().getDirectory(), "plugins").toFile();
            Path sourceFilePath = f.toPath();
            Path targetFilePath = new File(targetFolder.toPath().toString() + File.separator + f.getName()).toPath();
            Files.copy(sourceFilePath, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected boolean isNotAlreadyPresentInMuleContainer(Dependency mulePlugin) {
        return !this.containerPlugins.contains(mulePlugin.getGroupId() + ":" + mulePlugin.getArtifactId());
    }

    protected void createMuleSourceFolderContent() throws IOException {
        File targetFolder = Paths.get(this.project.getBuild().getDirectory(), "META-INF", "mule-src", this.project.getArtifactId()).toFile();
        CopyFileVisitor visitor = new CopyFileVisitor(this.projectBaseFolder, targetFolder);
        ArrayList<Path> exclusions = new ArrayList<Path>();
        exclusions.add(Paths.get(this.projectBaseFolder.toPath().toString(), "target"));
        visitor.setExclusions(exclusions);
        Files.walkFileTree(this.projectBaseFolder.toPath(), visitor);
    }

    protected void createDescriptorFilesContent() throws IOException {
        this.copyFileFromRootToRoot("pom.xml");
        this.copyFileFromRootToRoot("mule-app.properties");
        this.copyFileFromRootToRoot("mule-deploy.properties");
    }

    protected void copyFileFromRootToRoot(String source) throws IOException {
        File targetFolder = new File(this.project.getBuild().getDirectory());
        Path sourceFilePath = new File(this.projectBaseFolder.getCanonicalPath() + File.separator + source).toPath();
        Path targetFilePath = new File(targetFolder.toPath().toString() + File.separator + source).toPath();
        Files.copy(sourceFilePath, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
    }

    protected void initializeResolver() {
        this.mulePluginResolver = new MulePluginResolver(this.getLog(), this.session, this.projectBuilder, this.repositorySystem, this.localRepository, this.remoteArtifactRepositories);
    }

    protected void initializeApplicationDependencySelector() {
        this.applicationDependencySelector = new ApplicationDependencySelector();
    }
}

