/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.artifact.AttachedArtifact;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.tools.artifact.archiver.api.PackageBuilder;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PackageMojo
extends AbstractMuleMojo {
    private static final String TYPE = "zip";
    @Component
    private ArtifactHandlerManager handlerManager;
    @Parameter(defaultValue="${finalName}")
    protected String finalName;
    @Parameter(defaultValue="${onlyMuleSources}")
    protected boolean onlyMuleSources = false;
    @Parameter(defaultValue="${attachMuleSources}")
    protected boolean attachMuleSources = false;
    protected PackageBuilder packageBuilder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String targetFolder = this.project.getBuild().getDirectory();
        File destinationFile = new File(targetFolder, this.getFinalName() + "." + TYPE);
        try {
            this.createMuleApp(destinationFile, targetFolder);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule App", (Exception)((Object)e));
        }
        this.setProjectArtifactTypeToZip(destinationFile);
    }

    protected void setProjectArtifactTypeToZip(File destinationFile) {
        ArtifactHandler handler = this.handlerManager.getArtifactHandler(TYPE);
        AttachedArtifact artifact = new AttachedArtifact(this.project.getArtifact(), TYPE, handler);
        artifact.setFile(destinationFile);
        artifact.setResolved(true);
        this.project.setArtifact((Artifact)artifact);
    }

    protected void createMuleApp(File destinationFile, String targetFolder) throws MojoExecutionException, ArchiverException {
        this.initializePackageBuilder();
        try {
            PackageBuilder builder = this.packageBuilder.withDestinationFile(destinationFile);
            if (!this.onlyMuleSources) {
                builder.withClasses(new File(targetFolder + File.separator + "classes")).withLib(new File(targetFolder + File.separator + "lib")).withMule(new File(targetFolder + File.separator + "mule")).withPlugins(new File(targetFolder + File.separator + "plugins")).withMuleAppProperties(new File(targetFolder + File.separator + "mule-app.properties")).withMuleDeployProperties(new File(targetFolder + File.separator + "mule-deploy.properties")).withPom(new File(targetFolder + File.separator + "pom.xml"));
                if (this.attachMuleSources) {
                    builder.withMetaInf(new File(targetFolder + File.separator + "META-INF"));
                }
            } else {
                builder.withMetaInf(new File(targetFolder + File.separator + "META-INF"));
            }
            builder.createDeployableFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create archive");
        }
    }

    private String getFinalName() {
        if (this.finalName == null) {
            this.finalName = this.project.getArtifactId() + "-" + this.project.getVersion();
        }
        this.getLog().debug((CharSequence)("Using final name: " + this.finalName));
        return this.finalName;
    }

    protected void initializePackageBuilder() {
        this.packageBuilder = new PackageBuilder();
    }
}

