/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="initialize", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class InitializeMojo
extends AbstractMuleMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Initializing Mule Maven Plugin...");
        String targetFolder = this.project.getBuild().getDirectory();
        this.createFolderIfNecessary(targetFolder);
        this.createFolderIfNecessary(targetFolder + File.separator + "lib");
        this.createFolderIfNecessary(targetFolder + File.separator + "mule");
        this.createFolderIfNecessary(targetFolder + File.separator + "test-mule");
        this.createFolderIfNecessary(targetFolder + File.separator + "test-mule" + File.separator + "munit");
        this.createFolderIfNecessary(targetFolder + File.separator + "plugins");
        this.createFolderIfNecessary(targetFolder + File.separator + "META-INF");
        this.createFolderIfNecessary(targetFolder + File.separator + "META-INF" + File.separator + "mule-src");
        this.getLog().debug((CharSequence)"Mule Maven Plugin Initialize done");
    }

    private void createFolderIfNecessary(String folder) {
        File f = new File(folder);
        if (!f.exists()) {
            new File(folder).mkdir();
        }
    }
}

