/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.maven.dependency.MulePluginsCompatibilityValidator;
import org.mule.tools.maven.dependency.resolver.MulePluginResolver;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
public class ValidateMojo
extends AbstractMuleMojo {
    protected MulePluginResolver resolver;
    protected MulePluginsCompatibilityValidator validator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Validating Mule application...");
        this.validateMandatoryFolders();
        this.validateMandatoryDescriptors();
        this.validateMulePluginDependencies();
        this.getLog().debug((CharSequence)"Validating Mule application done");
    }

    private void validateMandatoryFolders() throws MojoExecutionException {
        if (!this.muleSourceFolder.exists()) {
            String message = String.format("Invalid Mule project. Missing src/main/mule folder. This folder is mandatory", new Object[0]);
            throw new MojoExecutionException(message);
        }
    }

    private void validateMandatoryDescriptors() throws MojoExecutionException {
        File muleConfigFile = Paths.get(this.projectBaseFolder.toString(), "mule-config.xml").toFile();
        File muleAppPropertiesFile = Paths.get(this.projectBaseFolder.toString(), "mule-app.properties").toFile();
        File muleDeployPropertiesFile = Paths.get(this.projectBaseFolder.toString(), "mule-deploy.properties").toFile();
        if (!muleAppPropertiesFile.exists()) {
            String message = String.format("Invalid Mule project. Missing %s file, it must be present in the root of application", "mule-app.properties");
            throw new MojoExecutionException(message);
        }
        if (!muleDeployPropertiesFile.exists() && !muleConfigFile.exists()) {
            String message = String.format("Invalid Mule project. Either %s or %s files must be present in the root of application", "mule-deploy.properties", "mule-config.xml");
            throw new MojoExecutionException(message);
        }
    }

    private void validateMulePluginDependencies() throws MojoExecutionException {
        this.initializeResolver();
        this.initializeValidator();
        this.validator.validate(this.resolver.resolveMulePlugins(this.project));
    }

    protected void initializeResolver() {
        this.resolver = new MulePluginResolver(this.getLog(), this.session, this.projectBuilder, this.repositorySystem, this.localRepository, this.remoteArtifactRepositories);
    }

    protected void initializeValidator() {
        this.validator = new MulePluginsCompatibilityValidator();
    }
}

