/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.artifact.archiver.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.tools.artifact.archiver.internal.MuleArchiver;
import org.mule.tools.artifact.archiver.internal.packaging.PackagingMode;
import org.mule.tools.artifact.archiver.internal.packaging.PackagingModeFactory;

public class PackageBuilder {
    private PackagingMode packagingMode;
    private transient Log log = LogFactory.getLog(this.getClass());
    private File muleFolder = null;
    private File policyFolder = null;
    private File classesFolder = null;
    private File repositoryFolder = null;
    private File mavenFolder = null;
    private File muleSrcFolder = null;
    private File muleArtifactFolder = null;
    private List<File> rootResources = new ArrayList<File>();
    private File destinationFile;
    private MuleArchiver archiver = null;

    public PackageBuilder(PackagingMode packagingMode) {
        this.packagingMode = packagingMode;
    }

    public PackageBuilder() {
        this(PackagingModeFactory.getDefaultPackaging());
    }

    public MuleArchiver getMuleArchiver() {
        if (this.archiver == null) {
            this.archiver = new MuleArchiver();
        }
        return this.archiver;
    }

    public PackageBuilder withArchiver(MuleArchiver archiver) {
        Preconditions.checkNotNull((Object)((Object)archiver), (Object)"The org.mule.tools.artifact.org.mule.tools.artifact.archiver must not be null");
        this.archiver = archiver;
        return this;
    }

    public PackageBuilder withClasses(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.classesFolder = folder;
        return this;
    }

    public PackageBuilder withMule(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0);
        this.muleFolder = folder;
        return this;
    }

    public PackageBuilder withPolicy(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0);
        this.policyFolder = folder;
        return this;
    }

    public PackageBuilder withMaven(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.mavenFolder = folder;
        return this;
    }

    public PackageBuilder withMuleSrc(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.muleSrcFolder = folder;
        return this;
    }

    public PackageBuilder withMuleArtifact(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.muleArtifactFolder = folder;
        return this;
    }

    public PackageBuilder withRepository(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.repositoryFolder = folder;
        return this;
    }

    public PackageBuilder withRootResource(File resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"The resource must not be null");
        this.rootResources.add(resource);
        return this;
    }

    public PackageBuilder withDestinationFile(File file) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"The file must not be null");
        Preconditions.checkArgument((!file.exists() ? 1 : 0) != 0, (Object)"The file must not be duplicated");
        this.destinationFile = file;
        return this;
    }

    public void createDeployableFile() throws IOException {
        this.runPrePackageValidations();
        MuleArchiver archiver = this.getMuleArchiver();
        if (null != this.muleFolder && this.muleFolder.exists() && this.muleFolder.isDirectory()) {
            archiver.addMule(this.muleFolder, null, null);
        }
        if (null != this.policyFolder && this.policyFolder.exists() && this.policyFolder.isDirectory()) {
            archiver.addPolicy(this.policyFolder, null, null);
        }
        if (null != this.classesFolder && this.classesFolder.exists() && this.classesFolder.isDirectory()) {
            archiver.addClasses(this.classesFolder, null, null);
        }
        if (null != this.mavenFolder && this.mavenFolder.exists() && this.mavenFolder.isDirectory()) {
            archiver.addMaven(this.mavenFolder, null, null);
        }
        if (null != this.muleArtifactFolder && this.muleArtifactFolder.exists() && this.muleArtifactFolder.isDirectory()) {
            archiver.addMuleArtifact(this.muleArtifactFolder, null, null);
        }
        if (null != this.muleSrcFolder && this.muleSrcFolder.exists() && this.muleSrcFolder.isDirectory()) {
            archiver.addMuleSrc(this.muleSrcFolder, null, null);
        }
        if (null != this.repositoryFolder && this.repositoryFolder.exists() && this.repositoryFolder.isDirectory()) {
            archiver.addRepository(this.repositoryFolder, null, null);
        }
        if (null != this.muleSrcFolder && this.muleSrcFolder.exists() && this.muleSrcFolder.isDirectory()) {
            archiver.addMuleSrc(this.muleSrcFolder, null, null);
        }
        archiver.setDestFile(this.destinationFile);
        archiver.createArchive();
    }

    private void runPrePackageValidations() {
        Preconditions.checkArgument((this.destinationFile != null ? 1 : 0) != 0, (Object)"The destination file has not been set");
    }

    private void checkMandatoryFolder(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exists");
        Preconditions.checkArgument((boolean)folder.isDirectory(), (Object)"The folder must be a valid directory");
    }

    public PackageBuilder addRootResourcesFile(File file) {
        return this;
    }

    public void generateArtifact(File targetFolder, File destinationFile) throws IOException {
        this.checkMandatoryFolder(targetFolder);
        Preconditions.checkArgument((destinationFile != null && !destinationFile.exists() ? 1 : 0) != 0, (Object)"Destination file must not be null or already exist");
        File[] files = targetFolder.listFiles();
        if (files == null || files.length == 0) {
            this.log.warn((Object)"The provided target folder is empty, no file will be generated");
            return;
        }
        Map<String, File> fileMap = Arrays.stream(files).collect(Collectors.toMap(File::getName, Function.identity()));
        try {
            this.packagingMode.applyPackaging(this, fileMap).withDestinationFile(destinationFile);
        }
        catch (IllegalArgumentException e) {
            this.log.warn((Object)"The provided target folder does not have the expected structure");
            return;
        }
        this.createDeployableFile();
        this.log.info((Object)("File " + destinationFile.getName() + " has been successfully created"));
    }
}

