/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.artifact.archiver.internal;

import java.io.File;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;

public class MuleArchiver
extends ZipArchiver {
    public static final String ROOT_LOCATION = "";
    public static final String CLASSES_LOCATION = "classes" + File.separator;
    public static final String MULE_LOCATION = "mule" + File.separator;
    public static final String POLICY_LOCATION = "policy" + File.separator;
    public static final String META_INF_LOCATION = "META-INF" + File.separator;
    public static final String MAVEN_LOCATION = META_INF_LOCATION + "maven" + File.separator;
    public static final String MULE_SRC_LOCATION = META_INF_LOCATION + "mule-src" + File.separator;
    public static final String MULE_ARTIFACT_LOCATION = META_INF_LOCATION + "mule-artifact" + File.separator;
    public static final String REPOSITORY_LOCATION = "repository" + File.separator;

    public void addClasses(File file) throws ArchiverException {
        this.addFile(file, CLASSES_LOCATION + file.getName());
    }

    public void addClasses(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, CLASSES_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addMuleSrc(File file) throws ArchiverException {
        this.addFile(file, MULE_SRC_LOCATION + file.getName());
    }

    public void addMuleSrc(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, MULE_SRC_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addMaven(File file) throws ArchiverException {
        this.addFile(file, MAVEN_LOCATION + file.getName());
    }

    public void addMaven(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, MAVEN_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addMuleArtifact(File file) throws ArchiverException {
        this.addFile(file, MULE_ARTIFACT_LOCATION + file.getName());
    }

    public void addMuleArtifact(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, MULE_ARTIFACT_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addRepository(File file) throws ArchiverException {
        this.addFile(file, REPOSITORY_LOCATION + file.getName());
    }

    public void addRepository(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, REPOSITORY_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addMule(File file) throws ArchiverException {
        this.addFile(file, MULE_LOCATION + file.getName());
    }

    public void addMule(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, MULE_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addPolicy(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, POLICY_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addRootDirectory(File directory) throws ArchiverException {
        this.addDirectory(directory, ROOT_LOCATION, null, this.addDefaultExcludes(null));
    }

    @Deprecated
    public void addRootFile(File file) throws ArchiverException {
        this.addFile(file, ROOT_LOCATION + file.getName());
    }

    private String[] addDefaultExcludes(String[] excludes) {
        if (excludes == null || excludes.length == 0) {
            return DirectoryScanner.DEFAULTEXCLUDES;
        }
        String[] newExcludes = new String[excludes.length + DirectoryScanner.DEFAULTEXCLUDES.length];
        System.arraycopy(DirectoryScanner.DEFAULTEXCLUDES, 0, newExcludes, 0, DirectoryScanner.DEFAULTEXCLUDES.length);
        System.arraycopy(excludes, 0, newExcludes, DirectoryScanner.DEFAULTEXCLUDES.length, excludes.length);
        return newExcludes;
    }
}

