/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.artifact.archiver.internal.packaging;

import com.google.common.base.CaseFormat;
import java.io.File;
import java.util.Map;
import org.mule.tools.artifact.archiver.internal.PackageBuilder;

public enum PackagingMode {
    SOURCES{

        @Override
        public PackageBuilder applyPackaging(PackageBuilder packageBuilder, Map<String, File> fileMap) {
            return packageBuilder.withMuleSrc(fileMap.get("mule-src"));
        }
    }
    ,
    BINARIES{

        @Override
        public PackageBuilder applyPackaging(PackageBuilder packageBuilder, Map<String, File> fileMap) {
            return packageBuilder.withMule(fileMap.get("mule")).withClasses(fileMap.get("classes")).withRepository(fileMap.get("repository"));
        }
    }
    ,
    BINARIES_AND_SOURCES{

        @Override
        public PackageBuilder applyPackaging(PackageBuilder packageBuilder, Map<String, File> fileMap) {
            return packageBuilder.withClasses(fileMap.get("classes")).withMule(fileMap.get("mule"));
        }
    };


    public static PackagingMode fromString(String name) {
        String packagingName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name);
        return PackagingMode.valueOf(packagingName);
    }

    public abstract PackageBuilder applyPackaging(PackageBuilder var1, Map<String, File> var2);
}

