/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.mule.tools.maven.DependencyMapBuilder;

public class ApplicationDependencySelector {
    public List<Dependency> select(List<Dependency> mulePlugins) {
        ArrayList<Dependency> selectedDependencies = new ArrayList<Dependency>();
        Map<String, List<Dependency>> dependencyMap = new DependencyMapBuilder().build(mulePlugins);
        selectedDependencies.addAll(dependencyMap.entrySet().stream().map(entry -> this.getNewerPluginFile((List)entry.getValue())).collect(Collectors.toList()));
        return selectedDependencies;
    }

    private Dependency getNewerPluginFile(List<Dependency> dependencyVersions) {
        if (dependencyVersions.size() == 1) {
            return dependencyVersions.get(0);
        }
        Dependency newerDependency = dependencyVersions.get(0);
        for (Dependency dependency : dependencyVersions) {
            if (dependency.getVersion().compareTo(newerDependency.getVersion()) <= 1) continue;
            newerDependency = dependency;
        }
        return newerDependency;
    }
}

