/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo.model;

import com.google.common.base.CaseFormat;
import java.util.Arrays;
import org.mule.tools.maven.mojo.model.Classifier;

public enum PackagingType {
    MULE_APPLICATION(Classifier.MULE_APPLICATION){

        @Override
        protected Classifier[] getClassifiers() {
            return new Classifier[]{Classifier.MULE_APPLICATION, Classifier.MULE_APPLICATION_EXAMPLE, Classifier.MULE_APPLICATION_TEMPLATE};
        }
    }
    ,
    MULE_DOMAIN(Classifier.MULE_DOMAIN){

        @Override
        protected Classifier[] getClassifiers() {
            return new Classifier[]{Classifier.MULE_DOMAIN};
        }
    }
    ,
    MULE_POLICY(Classifier.MULE_POLICY){

        @Override
        protected Classifier[] getClassifiers() {
            return new Classifier[]{Classifier.MULE_POLICY};
        }
    };

    protected Classifier defaultClassifier;

    protected abstract Classifier[] getClassifiers();

    private PackagingType(Classifier defaultClassifier) {
        this.defaultClassifier = defaultClassifier;
    }

    public String resolveClassifier(String classifierName, boolean lightwayPackage) {
        return Arrays.stream(this.getClassifiers()).filter(allowedClassifier -> allowedClassifier.equals(classifierName)).findFirst().orElse(this.defaultClassifier).toString() + (lightwayPackage ? "-light-package" : "");
    }

    public static PackagingType fromString(String name) {
        String packagingName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, name);
        try {
            return PackagingType.valueOf(packagingName);
        }
        catch (IllegalArgumentException e) {
            return MULE_APPLICATION;
        }
    }

    public boolean equals(String name) {
        return name == null ? false : PackagingType.fromString(name).equals((Object)this);
    }

    public String toString() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
    }
}

