/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo.model.lifecycle;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.mule.tools.maven.mojo.model.lifecycle.MavenLifecyclePhase;

public abstract class MuleLifecycleMappingMaven {
    private static final String DEFAULT_LIFECYCLE_ID = "default";

    public Map<String, Lifecycle> getLifecycles() {
        Lifecycle lifecycle = this.getDefaultLifecycle();
        HashMap<String, Lifecycle> lifecycleMap = new HashMap<String, Lifecycle>();
        lifecycleMap.put(lifecycle.getId(), lifecycle);
        return lifecycleMap;
    }

    private Lifecycle getDefaultLifecycle() {
        Lifecycle lifecycle = new Lifecycle();
        lifecycle.setId(DEFAULT_LIFECYCLE_ID);
        lifecycle.setPhases(this.getLifecyclePhases());
        return lifecycle;
    }

    private Map getLifecyclePhases() {
        HashMap<String, Object> phases = new HashMap<String, Object>();
        phases.put(MavenLifecyclePhase.VALIDATE.id(), this.buildGoals("org.mule.tools.maven:mule-maven-plugin:validate"));
        phases.put(MavenLifecyclePhase.INITIALIZE.id(), this.buildGoals("org.mule.tools.maven:mule-maven-plugin:initialize"));
        phases.put(MavenLifecyclePhase.GENERATE_SOURCES.id(), this.buildGoals("org.mule.tools.maven:mule-maven-plugin:generate-sources"));
        phases.put(MavenLifecyclePhase.PROCESS_SOURCES.id(), this.buildGoals("org.mule.tools.maven:mule-maven-plugin:process-sources"));
        phases.put(MavenLifecyclePhase.PROCESS_RESOURCES.id(), this.buildGoals("org.apache.maven.plugins:maven-resources-plugin:3.0.2:resources"));
        phases.put(MavenLifecyclePhase.COMPILE.id(), this.buildGoals("org.apache.maven.plugins:maven-compiler-plugin:3.6.1:compile"));
        phases.put(MavenLifecyclePhase.GENERATE_TEST_SOURCES.id(), this.buildGoals("org.mule.tools.maven:mule-maven-plugin:generate-test-sources"));
        phases.put(MavenLifecyclePhase.PROCESS_TEST_RESOURCES.id(), this.buildGoals("org.apache.maven.plugins:maven-resources-plugin:3.0.2:testResources"));
        phases.put(MavenLifecyclePhase.TEST_COMPILE.id(), this.buildGoals("org.apache.maven.plugins:maven-compiler-plugin:3.6.1:testCompile"));
        phases.put(MavenLifecyclePhase.TEST.id(), this.buildGoals("org.apache.maven.plugins:maven-surefire-plugin:2.19.1:test"));
        phases.put(MavenLifecyclePhase.PACKAGE.id(), this.buildGoals("org.mule.tools.maven:mule-maven-plugin:package"));
        phases.put(MavenLifecyclePhase.INSTALL.id(), this.buildGoals("org.apache.maven.plugins:maven-install-plugin:2.5.2:install"));
        phases.put(MavenLifecyclePhase.DEPLOY.id(), this.buildGoals("org.apache.maven.plugins:maven-deploy-plugin:2.8.2:deploy"));
        return phases;
    }

    protected abstract Object buildGoals(String var1);
}

