/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.util.FilenameUtils;

public class Undeployer {
    private List<File> muleHomes;
    private String applicationName;
    private Log log;

    public Undeployer(Log log, String applicationName, File ... muleHomes) {
        this.muleHomes = Arrays.asList(muleHomes);
        this.applicationName = applicationName;
        this.log = log;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        for (File muleHome : this.muleHomes) {
            this.log.info((CharSequence)("Undeploying application " + this.applicationName + " from " + muleHome.getAbsolutePath()));
            this.undeploy(muleHome);
            this.log.info((CharSequence)("Application " + this.applicationName + " undeployed"));
            this.log.info((CharSequence)("Stopping Mule instance " + muleHome.getAbsolutePath()));
            MuleProcessController controller = new MuleProcessController(muleHome.getAbsolutePath());
            controller.stop(new String[0]);
            this.log.info((CharSequence)"Mule instance stopped");
        }
    }

    private void undeploy(File muleHome) throws MojoExecutionException {
        File appsDir = new File(muleHome + "/apps/");
        for (File file : appsDir.listFiles()) {
            if (!FilenameUtils.getBaseName((String)file.getName()).equals(this.applicationName)) continue;
            try {
                this.log.debug((CharSequence)("Deleting " + file));
                FileUtils.forceDelete((File)file);
                return;
            }
            catch (IOException e) {
                this.log.error((CharSequence)("Could not delete " + file.getAbsolutePath()));
                throw new MojoExecutionException("Could not delete directory [" + file.getAbsolutePath() + "]", (Exception)e);
            }
        }
        throw new MojoExecutionException("Application " + this.applicationName + " not found.");
    }
}

