/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule.arm;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.maven.plugin.mule.AbstractDeployer;
import org.mule.tools.maven.plugin.mule.ApiException;
import org.mule.tools.maven.plugin.mule.DeploymentException;
import org.mule.tools.maven.plugin.mule.TargetType;
import org.mule.tools.maven.plugin.mule.arm.ArmApi;

public class ArmDeployer
extends AbstractDeployer {
    private final TargetType targetType;
    private final String target;
    private final ArmApi armApi;

    public ArmDeployer(String uri, String username, String password, String environment, TargetType targetType, String target, File application, String applicationName, Log log, String businessGroup, boolean armInsecure) {
        super(applicationName, application, log);
        this.targetType = targetType;
        this.target = target;
        this.armApi = new ArmApi(log, uri, username, password, environment, businessGroup, armInsecure);
    }

    @Override
    public void deploy() throws DeploymentException {
        try {
            this.armApi.init();
            Integer applicationId = this.armApi.findApplication(this.getApplicationName(), this.targetType, this.target);
            if (applicationId == null) {
                this.info("Deploying application " + this.getApplicationName());
                this.armApi.deployApplication(this.getApplicationFile(), this.getApplicationName(), this.targetType, this.target);
            } else {
                String alreadyExistsMessage = "Found application %s on %s %s. Redeploying application...";
                this.info(String.format(alreadyExistsMessage, this.getApplicationName(), this.targetType.toString(), this.target));
                this.armApi.redeployApplication(applicationId, this.getApplicationFile(), this.getApplicationName(), this.targetType, this.target);
            }
        }
        catch (ApiException e) {
            this.error("Failed: " + e.getMessage());
            throw new DeploymentException("Failed to deploy application " + this.getApplicationName(), e);
        }
    }
}

