/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.repository;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ArtifactInstaller {
    private Log log;

    public ArtifactInstaller(Log log) {
        this.log = log;
    }

    public void installArtifact(File repositoryFile, Artifact artifact) throws MojoExecutionException {
        Preconditions.checkArgument((artifact != null ? 1 : 0) != 0, (Object)"Artifact to be installed should not be null");
        String artifactFilename = this.getFormattedFileName(artifact);
        File artifactFolderDestination = ArtifactInstaller.getFormattedOutputDirectory(repositoryFile, artifact);
        if (!artifactFolderDestination.exists()) {
            artifactFolderDestination.mkdirs();
        }
        File destinationArtifactFile = new File(artifactFolderDestination, artifactFilename);
        try {
            this.log.info((CharSequence)String.format("Adding artifact <%s%s>", "repository", destinationArtifactFile.getAbsolutePath().replaceFirst(Pattern.quote(repositoryFile.getAbsolutePath()), "")));
            FileUtils.copyFile((File)artifact.getFile(), (File)destinationArtifactFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was a problem while copying the artifact [%s] file [%s] to the destination [%s]", artifact.toString(), artifact.getFile().getAbsolutePath(), destinationArtifactFile.getAbsolutePath()), (Exception)e);
        }
    }

    protected String getFormattedFileName(Artifact artifact) {
        StringBuilder destFileName = new StringBuilder();
        String versionString = "-" + this.getNormalizedVersion(artifact);
        String classifierString = "";
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            classifierString = "-" + artifact.getClassifier();
        }
        destFileName.append(artifact.getArtifactId()).append(versionString);
        destFileName.append(classifierString).append(".");
        Optional<ArtifactHandler> artifactHandler = Optional.ofNullable(artifact.getArtifactHandler());
        String extension = artifactHandler.orElse((ArtifactHandler)new DefaultArtifactHandler(artifact.getType())).getExtension();
        destFileName.append(extension);
        return destFileName.toString();
    }

    protected String getNormalizedVersion(Artifact artifact) {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion())) {
            return artifact.getBaseVersion();
        }
        return artifact.getVersion();
    }

    protected static File getFormattedOutputDirectory(File outputDirectory, Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId().replace('.', File.separatorChar)).append(File.separatorChar);
        sb.append(artifact.getArtifactId()).append(File.separatorChar);
        sb.append(artifact.getBaseVersion()).append(File.separatorChar);
        return new File(outputDirectory, sb.toString());
    }
}

