/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.repository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;

public class ArtifactLocator {
    private Log log;
    private MavenProject project;
    private ProjectBuilder projectBuilder;
    private RepositorySystem repositorySystem;
    private ArtifactRepository localRepository;
    private ProjectBuildingRequest projectBuildingRequest;

    public ArtifactLocator(Log log, MavenProject project, ProjectBuilder projectBuilder, RepositorySystem repositorySystem, ArtifactRepository localRepository, ProjectBuildingRequest projectBuildingRequest) {
        this.log = log;
        this.project = project;
        this.projectBuilder = projectBuilder;
        this.repositorySystem = repositorySystem;
        this.localRepository = localRepository;
        this.projectBuildingRequest = projectBuildingRequest;
    }

    public Set<Artifact> getArtifacts() throws MojoExecutionException {
        HashSet<Artifact> artifacts = new HashSet<Artifact>(this.project.getArtifacts());
        for (Artifact dep : new ArrayList(artifacts)) {
            this.addThirdPartyParentPomArtifacts(artifacts, dep);
        }
        this.addParentPomArtifacts(artifacts);
        return artifacts;
    }

    protected void addThirdPartyParentPomArtifacts(Set<Artifact> artifacts, Artifact dep) throws MojoExecutionException {
        MavenProject project = this.buildProjectFromArtifact(dep);
        this.addParentDependencyPomArtifacts(project, artifacts);
        Artifact pomArtifact = this.repositorySystem.createProjectArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
        artifacts.add(this.getResolvedArtifactUsingLocalRepository(pomArtifact));
    }

    protected void addParentPomArtifacts(Set<Artifact> artifacts) throws MojoExecutionException {
        MavenProject currentProject = this.project;
        boolean projectParent = true;
        while (currentProject.hasParent() && projectParent) {
            if ((currentProject = currentProject.getParent()).getFile() == null) {
                projectParent = false;
                continue;
            }
            Artifact pomArtifact = currentProject.getArtifact();
            pomArtifact.setFile(currentProject.getFile());
            this.validatePomArtifactFile(pomArtifact);
            if (artifacts.add(pomArtifact)) continue;
            break;
        }
        if (!projectParent) {
            Artifact unresolvedParentPomArtifact = currentProject.getArtifact();
            this.addThirdPartyParentPomArtifacts(artifacts, unresolvedParentPomArtifact);
        }
    }

    protected MavenProject buildProjectFromArtifact(Artifact artifact) throws MojoExecutionException {
        MavenProject mavenProject;
        Artifact projectArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        try {
            mavenProject = this.projectBuilder.build(projectArtifact, this.projectBuildingRequest).getProject();
        }
        catch (ProjectBuildingException e) {
            this.log.warn((CharSequence)String.format("The artifact [%s] seems to have some warnings, enable logs for more information", artifact.toString()));
            if (this.log.isDebugEnabled()) {
                this.log.warn((CharSequence)String.format("The artifact [%s] had the following issue ", artifact.toString()), (Throwable)e);
            }
            if (e.getResults() == null || e.getResults().size() != 1) {
                throw new MojoExecutionException(String.format("There was an issue while trying to create a maven project from the artifact [%s]", artifact.toString()), (Exception)((Object)e));
            }
            ProjectBuildingResult projectBuildingResult = (ProjectBuildingResult)e.getResults().get(0);
            List collect = projectBuildingResult.getProblems().stream().filter(modelProblem -> modelProblem.getSeverity().equals((Object)ModelProblem.Severity.FATAL)).collect(Collectors.toList());
            if (!collect.isEmpty()) {
                throw new MojoExecutionException(String.format("There was an issue while trying to create a maven project from the artifact [%s], several FATAL errors were found", artifact.toString()), (Exception)((Object)e));
            }
            mavenProject = projectBuildingResult.getProject();
        }
        return mavenProject;
    }

    protected void addParentDependencyPomArtifacts(MavenProject projectDependency, Set<Artifact> artifacts) throws MojoExecutionException {
        Artifact pomArtifact;
        MavenProject currentProject = projectDependency;
        while (currentProject.hasParent() && artifacts.add(this.getResolvedArtifactUsingLocalRepository(pomArtifact = (currentProject = currentProject.getParent()).getArtifact()))) {
        }
    }

    protected Artifact getResolvedArtifactUsingLocalRepository(Artifact pomArtifact) throws MojoExecutionException {
        Artifact resolvedPomArtifact = this.localRepository.find(pomArtifact);
        this.validatePomArtifactFile(resolvedPomArtifact);
        return resolvedPomArtifact;
    }

    protected void validatePomArtifactFile(Artifact resolvedPomArtifact) throws MojoExecutionException {
        if (resolvedPomArtifact.getFile() == null) {
            throw new MojoExecutionException(String.format("There was a problem trying to resolve the artifact's file location for [%s], file was null", resolvedPomArtifact.toString()));
        }
        if (!resolvedPomArtifact.getFile().exists()) {
            throw new MojoExecutionException(String.format("There was a problem trying to resolve the artifact's file location for [%s], file [%s] doesn't exist", resolvedPomArtifact.toString(), resolvedPomArtifact.getFile().getAbsolutePath()));
        }
    }
}

