/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.api.packager.ContentGenerator;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="generate-test-sources", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateTestSourcesMojo
extends AbstractMuleMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        long start = System.currentTimeMillis();
        this.getLog().debug((CharSequence)"Generating test source code...");
        try {
            this.getContentGenerator().createTestFolderContent();
        }
        catch (IOException | IllegalArgumentException e) {
            throw new MojoFailureException("Fail to generate sources", (Throwable)e);
        }
        this.getLog().debug((CharSequence)MessageFormat.format("Test source code generation done ({0}ms)", System.currentTimeMillis() - start));
    }

    @Override
    protected ContentGenerator getContentGenerator() {
        return new ContentGenerator(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), PackagingType.fromString((String)this.project.getPackaging()), Paths.get(this.projectBaseFolder.toURI()), Paths.get(this.project.getBuild().getDirectory(), new String[0]));
    }
}

