/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.tools.api.packager.PackageBuilder;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PackageMojo
extends AbstractMuleMojo {
    private static final String TYPE = "jar";
    @Component
    protected MavenProjectHelper helper;
    @Parameter(defaultValue="${onlyMuleSources}")
    protected boolean onlyMuleSources = false;
    @Parameter(defaultValue="${attachMuleSources}")
    protected boolean attachMuleSources = false;
    protected PackagingType packagingType;

    public void execute() throws MojoExecutionException, MojoFailureException {
        long start = System.currentTimeMillis();
        this.getLog().debug((CharSequence)"Packaging...");
        this.packagingType = PackagingType.fromString((String)this.project.getPackaging());
        String targetFolder = this.project.getBuild().getDirectory();
        File destinationFile = this.getDestinationFile(targetFolder);
        try {
            this.getPackageBuilder().createMuleApp(destinationFile, targetFolder, this.packagingType, this.onlyMuleSources, this.lightweightPackage, this.attachMuleSources);
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule App", (Exception)e);
        }
        this.helper.attachArtifact(this.project, TYPE, this.packagingType.resolveClassifier(this.classifier, this.lightweightPackage), destinationFile);
        this.getLog().debug((CharSequence)MessageFormat.format("Package done ({0}ms)", System.currentTimeMillis() - start));
    }

    protected File getDestinationFile(String targetFolder) throws MojoExecutionException {
        Preconditions.checkArgument((targetFolder != null ? 1 : 0) != 0, (Object)"The target folder must not be null");
        Path destinationPath = Paths.get(targetFolder, this.getFileName());
        try {
            Files.deleteIfExists(destinationPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Exception deleting the file [%s]", destinationPath), (Exception)e);
        }
        return destinationPath.toFile();
    }

    protected String getFileName() {
        return this.project.getBuild().getFinalName() + "-" + this.packagingType.resolveClassifier(this.classifier, this.lightweightPackage) + "." + TYPE;
    }

    public PackageBuilder getPackageBuilder() {
        return new PackageBuilder();
    }
}

