/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.text.MessageFormat;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.tools.api.classloader.model.ApplicationClassLoaderModelAssembler;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.repository.ArtifactInstaller;
import org.mule.tools.api.repository.MuleMavenPluginClientProvider;
import org.mule.tools.api.repository.RepositoryGenerator;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="process-sources", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ProcessSourcesMojo
extends AbstractMuleMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        long start = System.currentTimeMillis();
        this.getLog().debug((CharSequence)"Processing sources...");
        if (!this.lightweightPackage) {
            RepositoryGenerator repositoryGenerator = new RepositoryGenerator(this.project.getFile(), this.outputDirectory, new ArtifactInstaller(this.getLog()), this.getClassLoaderModelAssembler());
            try {
                ClassLoaderModel classLoaderModel = repositoryGenerator.generate();
                this.getContentGenerator().createApplicationClassLoaderModelJsonFile(classLoaderModel);
            }
            catch (Exception e) {
                String message = String.format("There was an exception while creating the repository of [%s]", this.project.toString());
                throw new MojoFailureException(message, (Throwable)e);
            }
        }
        this.getLog().debug((CharSequence)MessageFormat.format("Process sources done ({0}ms)", System.currentTimeMillis() - start));
    }

    protected ApplicationClassLoaderModelAssembler getClassLoaderModelAssembler() {
        List remoteRepositories = RepositoryUtils.toRepos((List)this.remoteArtifactRepositories);
        AetherMavenClient aetherMavenClient = new MuleMavenPluginClientProvider(remoteRepositories, this.getLog()).buildMavenClient();
        return new ApplicationClassLoaderModelAssembler(aetherMavenClient);
    }
}

