/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.util.ProjectBuilder;
import org.mule.tools.api.validation.MulePluginResolver;
import org.mule.tools.api.validation.MulePluginsCompatibilityValidator;
import org.mule.tools.api.validation.Validator;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.utils.DependencyProject;
import org.mule.tools.maven.utils.MavenProjectBuilder;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
public class ValidateMojo
extends AbstractMuleMojo {
    private Validator validator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skipValidation) {
            long start = System.currentTimeMillis();
            this.getLog().debug((CharSequence)"Validating Mule application...");
            try {
                this.getValidator().isProjectValid(this.project.getPackaging());
                this.getMulePluginsCompatibilityValidator().validate(this.getResolver().resolveMulePlugins((Project)new DependencyProject(this.project)));
                this.getValidator().validateSharedLibraries(this.sharedLibraries, this.toArtifactCoordinates(this.project.getDependencies()));
            }
            catch (ValidationException e) {
                throw new MojoExecutionException("Validation exception", (Exception)((Object)e));
            }
            this.getLog().debug((CharSequence)MessageFormat.format("Validation for Mule application done ({0}ms)", System.currentTimeMillis() - start));
        } else {
            this.getLog().debug((CharSequence)"Skipping Validation for Mule application");
        }
    }

    private List<ArtifactCoordinates> toArtifactCoordinates(List<Dependency> dependencies) {
        return dependencies.stream().map(d -> new ArtifactCoordinates(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getType(), d.getClassifier())).collect(Collectors.toList());
    }

    protected Validator getValidator() {
        if (this.validator == null) {
            this.validator = new Validator(this.projectBaseFolder.toPath());
        }
        return this.validator;
    }

    protected MulePluginResolver getResolver() {
        MavenProjectBuilder builder = new MavenProjectBuilder(this.getLog(), this.session, this.projectBuilder, this.repositorySystem, this.localRepository, this.remoteArtifactRepositories);
        return new MulePluginResolver((ProjectBuilder)builder);
    }

    protected MulePluginsCompatibilityValidator getMulePluginsCompatibilityValidator() {
        return new MulePluginsCompatibilityValidator();
    }
}

