/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo.deploy;

import groovy.util.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.maven.mojo.deploy.logging.MavenDeployerLog;
import org.mule.tools.model.DeployerLog;
import org.mule.tools.model.DeploymentConfiguration;
import org.mule.tools.model.DeploymentConfigurator;

public abstract class AbstractMuleDeployerMojo
extends AbstractMojo {
    @Parameter
    protected DeploymentConfiguration deploymentConfiguration;
    @Component
    protected Settings settings;
    @Component
    protected SettingsDecrypter decrypter;
    @Component
    protected MavenProject mavenProject;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;
    private DeploymentConfigurator deploymentConfigurator;
    protected DeployerLog log;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.log = new MavenDeployerLog(this.getLog());
        if (this.deploymentConfiguration == null) {
            throw new MojoFailureException("No deployment configuration was defined. Aborting.");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.deploymentConfiguration.getSkip()) && "true".equals(this.deploymentConfiguration.getSkip())) {
            this.getLog().info((CharSequence)("Skipping execution: skip=" + this.deploymentConfiguration.getSkip()));
        } else {
            this.deploymentConfigurator = new DeploymentConfigurator(this.deploymentConfiguration, (DeployerLog)new MavenDeployerLog(this.getLog()));
            this.getLog().debug((CharSequence)("Executing mojo, skip=" + this.deploymentConfiguration.getSkip()));
            try {
                this.doExecute();
            }
            catch (ScriptException | DeploymentException e) {
                throw new MojoFailureException("Deployment has failed.", e);
            }
        }
    }

    protected void doExecute() throws MojoExecutionException, MojoFailureException, ScriptException, DeploymentException {
        this.deploymentConfigurator.initializeApplication(this.artifactFactory, this.mavenProject, this.artifactResolver, this.localRepository);
        this.deploymentConfigurator.initializeEnvironment(this.settings, this.decrypter);
        switch (this.deploymentConfiguration.getDeploymentType()) {
            case standalone: {
                this.standalone();
                break;
            }
            case cluster: 
            case arm: 
            case cloudhub: 
            case agent: {
                throw new MojoExecutionException("The deploymentConfiguration type " + this.deploymentConfiguration.getDeploymentType() + " is not yet available.");
            }
            default: {
                throw new MojoFailureException("Unsupported deploymentConfiguration type: " + this.deploymentConfiguration.getDeploymentType());
            }
        }
    }

    protected abstract void cluster() throws MojoFailureException, MojoExecutionException, ScriptException;

    protected abstract void standalone() throws MojoFailureException, MojoExecutionException, DeploymentException, ScriptException;

    protected abstract void arm() throws MojoFailureException, MojoExecutionException, ScriptException;

    protected abstract void cloudhub() throws MojoFailureException, MojoExecutionException, ScriptException;

    protected abstract void agent() throws MojoFailureException, MojoExecutionException, ScriptException;
}

