/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo.deploy;

import groovy.util.ScriptException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.mule.tools.client.AbstractDeployer;
import org.mule.tools.client.agent.AgentDeployer;
import org.mule.tools.client.arm.ArmDeployer;
import org.mule.tools.client.cloudhub.CloudhubDeployer;
import org.mule.tools.client.standalone.controller.MuleProcessController;
import org.mule.tools.client.standalone.deployment.ClusterDeployer;
import org.mule.tools.client.standalone.deployment.StandaloneDeployer;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.client.standalone.installer.MuleStandaloneInstaller;
import org.mule.tools.maven.mojo.deploy.AbstractMuleDeployerMojo;
import org.mule.tools.model.ArtifactDescription;
import org.mule.tools.model.DeploymentConfiguration;
import org.mule.tools.utils.GroovyUtils;

@Mojo(name="deploy", requiresProject=true)
public class DeployMojo
extends AbstractMuleDeployerMojo {
    private static final long DEFAULT_POLLING_DELAY = 1000L;
    private static final Integer MAX_CLUSTER_SIZE = 8;
    private MuleStandaloneInstaller muleStandaloneInstaller;
    @Component
    protected ArchiverManager archiverManager;

    @Override
    protected void cloudhub() throws MojoFailureException, MojoExecutionException, ScriptException {
        CloudhubDeployer deployer = new CloudhubDeployer(this.deploymentConfiguration.getUri(), this.deploymentConfiguration.getUsername(), this.deploymentConfiguration.getPassword(), this.deploymentConfiguration.getEnvironment(), this.deploymentConfiguration.getApplicationName(), this.deploymentConfiguration.getApplication(), this.deploymentConfiguration.getRegion(), this.deploymentConfiguration.getMuleVersion(), this.deploymentConfiguration.getWorkers(), this.deploymentConfiguration.getWorkerType(), this.getLog(), this.deploymentConfiguration.getProperties(), this.deploymentConfiguration.getBusinessGroup());
        this.deployWithDeployer((AbstractDeployer)deployer);
    }

    @Override
    protected void arm() throws MojoFailureException, MojoExecutionException, ScriptException {
        ArmDeployer deployer = new ArmDeployer(this.deploymentConfiguration.getUri(), this.deploymentConfiguration.getUsername(), this.deploymentConfiguration.getPassword(), this.deploymentConfiguration.getEnvironment(), this.deploymentConfiguration.getTargetType(), this.deploymentConfiguration.getTarget(), this.deploymentConfiguration.getApplication(), this.deploymentConfiguration.getApplicationName(), this.getLog(), this.deploymentConfiguration.getBusinessGroup(), this.deploymentConfiguration.isArmInsecure());
        this.deployWithDeployer((AbstractDeployer)deployer);
    }

    @Override
    protected void agent() throws MojoFailureException, MojoExecutionException, ScriptException {
        AgentDeployer deployer = new AgentDeployer(this.getLog(), this.deploymentConfiguration.getApplicationName(), this.deploymentConfiguration.getApplication(), this.deploymentConfiguration.getUri());
        this.deployWithDeployer((AbstractDeployer)deployer);
    }

    private void deployWithDeployer(AbstractDeployer deployer) throws MojoExecutionException, MojoFailureException, ScriptException {
        if (null != this.deploymentConfiguration.getScript()) {
            GroovyUtils.executeScript((MavenProject)this.mavenProject, (DeploymentConfiguration)this.deploymentConfiguration);
        }
        try {
            deployer.deploy();
        }
        catch (DeploymentException e) {
            this.getLog().error((CharSequence)("Failed to deploy " + this.deploymentConfiguration.getApplicationName() + ": " + e.getMessage()), (Throwable)e);
            throw new MojoFailureException("Failed to deploy [" + this.deploymentConfiguration.getApplication() + "]");
        }
    }

    @Override
    protected void cluster() throws MojoExecutionException, MojoFailureException, ScriptException {
        this.validateSize();
        File[] muleHomes = new File[this.deploymentConfiguration.getSize().intValue()];
        LinkedList<MuleProcessController> controllers = new LinkedList<MuleProcessController>();
        for (int i = 0; i < this.deploymentConfiguration.getSize(); ++i) {
            File buildDirectory = new File(this.mavenProject.getBuild().getDirectory(), "mule" + i);
            buildDirectory.mkdir();
            File home = this.getMuleStandaloneInstaller().doInstallMule(buildDirectory);
            controllers.add(new MuleProcessController(home.getAbsolutePath(), this.deploymentConfiguration.getTimeout()));
            muleHomes[i] = home;
        }
        this.renameApplicationToApplicationName();
        if (null != this.deploymentConfiguration.getScript()) {
            GroovyUtils.executeScript((MavenProject)this.mavenProject, (DeploymentConfiguration)this.deploymentConfiguration);
        }
        new ClusterDeployer(muleHomes, controllers, this.getLog(), this.deploymentConfiguration.getApplication(), this.deploymentConfiguration.getDeploymentTimeout().longValue(), this.deploymentConfiguration.getArguments(), 1000L).addLibraries(this.deploymentConfiguration.getLibs()).execute();
    }

    private void validateSize() throws MojoFailureException {
        if (this.deploymentConfiguration.getSize() > MAX_CLUSTER_SIZE) {
            throw new MojoFailureException("Cannot create cluster with more than 8 nodes");
        }
    }

    @Override
    protected void standalone() throws DeploymentException, ScriptException, MojoFailureException {
        File muleHome = this.deploymentConfiguration.getMuleHome();
        MuleProcessController mule = new MuleProcessController(muleHome.getAbsolutePath(), this.deploymentConfiguration.getTimeout());
        this.renameApplicationToApplicationName();
        StandaloneDeployer standaloneDeployer = new StandaloneDeployer(mule, this.log, this.deploymentConfiguration.getApplication(), this.deploymentConfiguration.getDeploymentTimeout(), this.deploymentConfiguration.getArguments(), Long.valueOf(1000L)).addLibraries(this.deploymentConfiguration.getLibs());
        standaloneDeployer.addDomainFromDeploymentConfiguration(this.deploymentConfiguration);
        List<File> libs = this.getDependencies(this.deploymentConfiguration, this.artifactFactory, this.artifactResolver, this.mavenProject, this.localRepository);
        standaloneDeployer.addLibraries(libs);
        if (null != this.deploymentConfiguration.getScript()) {
            GroovyUtils.executeScript((MavenProject)this.mavenProject, (DeploymentConfiguration)this.deploymentConfiguration);
        }
        standaloneDeployer.execute();
    }

    public List<File> getDependencies(DeploymentConfiguration configuration, ArtifactFactory factory, ArtifactResolver resolver, MavenProject project, ArtifactRepository repository) throws DeploymentException {
        ArrayList<File> libraries = new ArrayList<File>();
        for (ArtifactDescription artifact : configuration.getArtifactItems()) {
            libraries.add(this.getDependency(artifact, factory, resolver, project, repository));
        }
        return libraries;
    }

    protected File getDependency(ArtifactDescription artifactDescription, ArtifactFactory factory, ArtifactResolver resolver, MavenProject project, ArtifactRepository repository) throws DeploymentException {
        try {
            Artifact artifact = factory.createArtifact(artifactDescription.getGroupId(), artifactDescription.getArtifactId(), artifactDescription.getVersion(), null, artifactDescription.getType());
            this.log.info("Resolving " + artifact);
            resolver.resolve(artifact, project.getRemoteArtifactRepositories(), repository);
            return artifact.getFile();
        }
        catch (AbstractArtifactResolutionException e) {
            throw new DeploymentException("Couldn't download artifact: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new DeploymentException("Couldn't download artifact: " + e.getMessage());
        }
    }

    private void renameApplicationToApplicationName() throws MojoFailureException {
        if (!FilenameUtils.getBaseName((String)this.deploymentConfiguration.getApplication().getName()).equals(this.deploymentConfiguration.getApplicationName())) {
            try {
                File destApplication = new File(this.deploymentConfiguration.getApplication().getParentFile(), this.deploymentConfiguration.getApplicationName() + ".jar");
                FileUtils.copyFile((File)this.deploymentConfiguration.getApplication(), (File)destApplication);
                this.deploymentConfiguration.setApplication(destApplication);
            }
            catch (IOException e) {
                throw new MojoFailureException("Couldn't rename [" + this.deploymentConfiguration.getApplication() + "] to [" + this.deploymentConfiguration.getApplicationName() + "]");
            }
        }
    }

    public MuleStandaloneInstaller getMuleStandaloneInstaller() {
        if (this.muleStandaloneInstaller == null) {
            this.muleStandaloneInstaller = new MuleStandaloneInstaller(this.deploymentConfiguration, this.mavenProject, this.artifactResolver, this.archiverManager, this.artifactFactory, this.localRepository, this.getLog());
        }
        return this.muleStandaloneInstaller;
    }
}

