/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo.deploy;

import java.io.File;
import javax.ws.rs.NotFoundException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.mule.tools.client.agent.AgentClient;
import org.mule.tools.client.arm.ArmClient;
import org.mule.tools.client.cloudhub.CloudhubClient;
import org.mule.tools.client.standalone.deployment.StandaloneUndeployer;
import org.mule.tools.maven.mojo.deploy.AbstractMuleDeployerMojo;

@Mojo(name="undeploy", requiresProject=true)
public class UndeployMojo
extends AbstractMuleDeployerMojo {
    @Override
    protected void cloudhub() throws MojoFailureException {
        CloudhubClient cloudhubClient = new CloudhubClient(this.deploymentConfiguration.getUri(), this.getLog(), this.deploymentConfiguration.getUsername(), this.deploymentConfiguration.getPassword(), this.deploymentConfiguration.getEnvironment(), this.deploymentConfiguration.getBusinessGroup());
        cloudhubClient.init();
        this.getLog().info((CharSequence)("Stopping application " + this.deploymentConfiguration.getApplicationName()));
        cloudhubClient.stopApplication(this.deploymentConfiguration.getApplicationName());
    }

    @Override
    protected void arm() throws MojoFailureException {
        ArmClient armClient = new ArmClient(this.getLog(), this.deploymentConfiguration.getUri(), this.deploymentConfiguration.getUsername(), this.deploymentConfiguration.getPassword(), this.deploymentConfiguration.getEnvironment(), this.deploymentConfiguration.getBusinessGroup(), this.deploymentConfiguration.isArmInsecure());
        armClient.init();
        this.getLog().info((CharSequence)("Undeploying application " + this.deploymentConfiguration.getApplicationName()));
        try {
            armClient.undeployApplication(this.deploymentConfiguration.getApplicationName(), this.deploymentConfiguration.getTargetType(), this.deploymentConfiguration.getTarget());
        }
        catch (NotFoundException e) {
            if (this.deploymentConfiguration.isFailIfNotExists()) {
                throw e;
            }
            this.getLog().warn((CharSequence)("Application not found: " + this.deploymentConfiguration.getApplicationName()));
        }
    }

    @Override
    protected void agent() throws MojoFailureException {
        AgentClient agentClient = new AgentClient(this.getLog(), this.deploymentConfiguration.getUri());
        this.getLog().info((CharSequence)("Undeploying application " + this.deploymentConfiguration.getApplicationName()));
        agentClient.undeployApplication(this.deploymentConfiguration.getApplicationName());
    }

    @Override
    protected void cluster() throws MojoFailureException, MojoExecutionException {
        File[] muleHomes = new File[this.deploymentConfiguration.getSize().intValue()];
        for (int i = 0; i < this.deploymentConfiguration.getSize(); ++i) {
            File parentDir = new File(this.mavenProject.getBuild().getDirectory(), "mule" + i);
            muleHomes[i] = new File(parentDir, "mule-enterprise-standalone-" + this.deploymentConfiguration.getMuleVersion());
            if (muleHomes[i].exists()) continue;
            throw new MojoFailureException(muleHomes[i].getAbsolutePath() + "directory does not exist.");
        }
        new StandaloneUndeployer(this.getLog(), this.deploymentConfiguration.getApplicationName(), muleHomes).execute();
    }

    @Override
    protected void standalone() throws MojoFailureException, MojoExecutionException {
        if (!this.deploymentConfiguration.getMuleHome().exists()) {
            throw new MojoFailureException("MULE_HOME directory does not exist.");
        }
        this.getLog().info((CharSequence)("Using MULE_HOME: " + this.deploymentConfiguration.getMuleHome()));
        new StandaloneUndeployer(this.getLog(), this.deploymentConfiguration.getApplicationName(), new File[]{this.deploymentConfiguration.getMuleHome()}).execute();
    }
}

