/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo.deploy;

import groovy.util.ScriptException;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.mule.tools.client.AbstractDeployer;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.maven.mojo.deploy.AbstractMuleDeployerMojo;
import org.mule.tools.maven.mojo.deploy.logging.MavenDeployerLog;
import org.mule.tools.model.standalone.MuleRuntimeDeployment;
import org.mule.tools.utils.DeployerFactory;
import org.mule.tools.utils.DeployerLog;
import org.mule.tools.utils.GroovyUtils;

@Mojo(name="deploy", requiresProject=true)
public class DeployMojo
extends AbstractMuleDeployerMojo {
    @Component
    protected ArchiverManager archiverManager;

    @Override
    public void execute() throws MojoFailureException, MojoExecutionException {
        super.execute();
        if (this.deploymentConfiguration instanceof MuleRuntimeDeployment) {
            this.runScript((MuleRuntimeDeployment)this.deploymentConfiguration);
        }
        try {
            AbstractDeployer deployer = new DeployerFactory().createDeployer(this.deploymentConfiguration, (DeployerLog)new MavenDeployerLog(this.getLog()));
            deployer.resolveDependencies(this.mavenProject, this.artifactResolver, this.archiverManager, this.artifactFactory, this.localRepository);
            deployer.deploy();
        }
        catch (ScriptException | DeploymentException e) {
            this.getLog().error((CharSequence)("Failed to deploy " + this.deploymentConfiguration.getApplicationName() + ": " + e.getMessage()), e);
            throw new MojoFailureException("Failed to deploy [" + this.deploymentConfiguration.getArtifact() + "]");
        }
    }

    private void runScript(MuleRuntimeDeployment deploymentConfiguration) throws MojoExecutionException {
        if (null != deploymentConfiguration.getScript()) {
            try {
                GroovyUtils.executeScript((MavenProject)this.mavenProject, (File)deploymentConfiguration.getScript());
            }
            catch (ScriptException e) {
                throw new MojoExecutionException("There was a problem trying to deploy the application: " + deploymentConfiguration.getApplicationName(), (Exception)((Object)e));
            }
        }
    }
}

