/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo.deploy.configuration;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.mule.tools.client.model.TargetType;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.agent.AgentDeployment;
import org.mule.tools.model.anypoint.AnypointDeployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.model.standalone.ClusterDeployment;
import org.mule.tools.model.standalone.MuleRuntimeDeployment;
import org.mule.tools.model.standalone.StandaloneDeployment;

public class DeploymentDefaultValuesSetter {
    public void setDefaultValues(Deployment deployment, MavenProject project) throws MojoExecutionException {
        if (deployment instanceof AgentDeployment) {
            this.setAgentDeploymentDefaultValues((AgentDeployment)deployment, project);
        } else if (deployment instanceof StandaloneDeployment) {
            this.setStandaloneDeploymentDefaultValues((StandaloneDeployment)deployment, project);
        } else if (deployment instanceof ClusterDeployment) {
            this.setClusterDeploymentDefaultValues((ClusterDeployment)deployment, project);
        } else if (deployment instanceof CloudHubDeployment) {
            this.setCloudHubDeploymentDefaultValues((CloudHubDeployment)deployment, project);
        } else if (deployment instanceof ArmDeployment) {
            this.setArmDeploymentDefaultValues((ArmDeployment)deployment, project);
        }
    }

    protected void setBasicDeploymentValues(Deployment deployment, MavenProject project) throws MojoExecutionException {
        String applicationPath;
        String muleVersion;
        String isSkip;
        String muleApplicationName = System.getProperty("mule.application.name");
        if (StringUtils.isNotBlank((CharSequence)muleApplicationName)) {
            deployment.setApplicationName(muleApplicationName);
        }
        if (StringUtils.isBlank((CharSequence)deployment.getApplicationName())) {
            deployment.setApplicationName(project.getArtifactId());
        }
        if (StringUtils.isNotBlank((CharSequence)(isSkip = System.getProperty("mule.skip")))) {
            deployment.setSkip(isSkip);
        }
        if (StringUtils.isBlank((CharSequence)deployment.getSkip())) {
            deployment.setSkip("false");
        }
        if (StringUtils.isNotBlank((CharSequence)(muleVersion = System.getProperty("mule.version")))) {
            deployment.setMuleVersion(muleVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)(applicationPath = System.getProperty("mule.artifact")))) {
            deployment.setArtifact(new File(applicationPath));
        }
        if (deployment.getArtifact() == null) {
            if (project.getAttachedArtifacts().isEmpty()) {
                throw new MojoExecutionException("Artifact to be deployed could not be found. Please set its location setting -Dmule.artifact=path/to/jar or in the deployment configuration pom element");
            }
            deployment.setArtifact(((Artifact)project.getAttachedArtifacts().get(0)).getFile());
        }
    }

    protected void setMuleRuntimeDeploymentValues(MuleRuntimeDeployment deployment, MavenProject project) throws MojoExecutionException {
        String muleHome;
        String arguments;
        String deploymentTimeout;
        String timeout;
        this.setBasicDeploymentValues((Deployment)deployment, project);
        String scriptLocation = System.getProperty("mule.script");
        if (StringUtils.isNotBlank((CharSequence)scriptLocation)) {
            deployment.setScript(new File(scriptLocation));
        }
        if (StringUtils.isNotBlank((CharSequence)(timeout = System.getProperty("mule.timeout")))) {
            deployment.setTimeout(Integer.valueOf(timeout).intValue());
        }
        if (StringUtils.isNotBlank((CharSequence)(deploymentTimeout = System.getProperty("mule.deploymentConfiguration.timeout")))) {
            deployment.setDeploymentTimeout(Long.valueOf(deploymentTimeout));
        }
        if (deployment.getDeploymentTimeout() == null) {
            deployment.setDeploymentTimeout(Long.valueOf(60000L));
        }
        if (StringUtils.isNotBlank((CharSequence)(arguments = System.getProperty("mule.arguments")))) {
            deployment.setArguments(arguments.split(","));
        }
        if (StringUtils.isNotBlank((CharSequence)(muleHome = System.getProperty("mule.home")))) {
            deployment.setMuleHome(new File(muleHome));
        }
        if (deployment.getMuleHome() == null) {
            throw new MojoExecutionException("Invalid deployment configuration, missing mule home value. Please set it either through the plugin configuration or -Dmule.home when building the current project");
        }
    }

    protected void setAnypointDeploymentValues(AnypointDeployment deployment, MavenProject project) throws MojoExecutionException {
        String username;
        String mavenServer;
        String password;
        String anypointEnvironment;
        String businessGroup;
        this.setBasicDeploymentValues((Deployment)deployment, project);
        String anypointUri = System.getProperty("anypoint.uri");
        if (StringUtils.isNotBlank((CharSequence)anypointUri)) {
            deployment.setUri(anypointUri);
        }
        if (StringUtils.isBlank((CharSequence)deployment.getUri())) {
            deployment.setUri("https://anypoint.mulesoft.com");
        }
        if (StringUtils.isNotBlank((CharSequence)(businessGroup = System.getProperty("anypoint.businessGroup")))) {
            deployment.setBusinessGroup(businessGroup);
        }
        if (StringUtils.isBlank((CharSequence)deployment.getBusinessGroup())) {
            deployment.setBusinessGroup("");
        }
        if (StringUtils.isNotBlank((CharSequence)(anypointEnvironment = System.getProperty("anypoint.environment")))) {
            deployment.setEnvironment(anypointEnvironment);
        }
        if (StringUtils.isNotBlank((CharSequence)(password = System.getProperty("anypoint.password")))) {
            deployment.setPassword(password);
        }
        if (StringUtils.isNotBlank((CharSequence)(mavenServer = System.getProperty("maven.server")))) {
            deployment.setServer(mavenServer);
        }
        if (StringUtils.isNotBlank((CharSequence)(username = System.getProperty("anypoint.username")))) {
            deployment.setUsername(username);
        }
    }

    protected void setAgentDeploymentDefaultValues(AgentDeployment deployment, MavenProject project) throws MojoExecutionException {
        this.setBasicDeploymentValues((Deployment)deployment, project);
        String anypointUri = System.getProperty("anypoint.uri");
        if (StringUtils.isNotBlank((CharSequence)anypointUri)) {
            deployment.setUri(anypointUri);
        }
        if (StringUtils.isBlank((CharSequence)deployment.getUri())) {
            deployment.setUri("https://anypoint.mulesoft.com");
        }
    }

    protected void setStandaloneDeploymentDefaultValues(StandaloneDeployment deployment, MavenProject project) throws MojoExecutionException {
        this.setMuleRuntimeDeploymentValues((MuleRuntimeDeployment)deployment, project);
    }

    protected void setClusterDeploymentDefaultValues(ClusterDeployment deployment, MavenProject project) throws MojoExecutionException {
        this.setMuleRuntimeDeploymentValues((MuleRuntimeDeployment)deployment, project);
        if (deployment.getSize() == null) {
            deployment.setSize(Integer.valueOf(2));
        }
    }

    protected void setArmDeploymentDefaultValues(ArmDeployment deployment, MavenProject project) throws MojoExecutionException {
        String targetType;
        String anypointTarget;
        this.setAnypointDeploymentValues((AnypointDeployment)deployment, project);
        String isArmInsecure = System.getProperty("arm.insecure");
        if (StringUtils.isNotBlank((CharSequence)isArmInsecure)) {
            deployment.setArmInsecure(Boolean.valueOf(isArmInsecure).booleanValue());
        }
        if (!deployment.isArmInsecure().isPresent()) {
            deployment.setArmInsecure(false);
        }
        if (!deployment.isFailIfNotExists().isPresent()) {
            deployment.setFailIfNotExists(Boolean.TRUE.booleanValue());
        }
        if (StringUtils.isNotBlank((CharSequence)(anypointTarget = System.getProperty("anypoint.target")))) {
            deployment.setTarget(anypointTarget);
        }
        if (StringUtils.isNotBlank((CharSequence)(targetType = System.getProperty("anypoint.target.type")))) {
            deployment.setTargetType(TargetType.valueOf((String)targetType));
        }
    }

    protected void setCloudHubDeploymentDefaultValues(CloudHubDeployment deployment, MavenProject project) throws MojoExecutionException {
        String cloudHubWorkerType;
        this.setAnypointDeploymentValues((AnypointDeployment)deployment, project);
        String cloudHubWorkers = System.getProperty("cloudhub.workers");
        if (StringUtils.isNotBlank((CharSequence)cloudHubWorkers)) {
            deployment.setWorkers(Integer.valueOf(cloudHubWorkers));
        }
        if (!deployment.getWorkers().isPresent()) {
            deployment.setWorkers(Integer.valueOf("1"));
        }
        if (StringUtils.isNotBlank((CharSequence)(cloudHubWorkerType = System.getProperty("cloudhub.workerType")))) {
            deployment.setWorkerType(cloudHubWorkerType);
        }
        if (StringUtils.isBlank((CharSequence)deployment.getWorkerType())) {
            deployment.setWorkerType("Medium");
        }
        if (StringUtils.isBlank((CharSequence)deployment.getRegion())) {
            deployment.setRegion(System.getProperty("cloudhub.region", "us-east-1"));
        }
    }
}

