/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.text.MessageFormat;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.validation.AbstractProjectValidator;
import org.mule.tools.api.validation.ProjectValidatorFactory;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.model.Deployment;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
public class ValidateMojo
extends AbstractMuleMojo {
    @Parameter
    protected Deployment deploymentConfiguration;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skipValidation) {
            long start = System.currentTimeMillis();
            this.getLog().debug((CharSequence)"Validating Mule application...");
            try {
                AbstractProjectValidator.isPackagingTypeValid((String)this.project.getPackaging());
                this.getProjectValidator().isProjectValid();
            }
            catch (ValidationException e) {
                throw new MojoExecutionException("Validation exception", (Exception)((Object)e));
            }
            this.getLog().debug((CharSequence)MessageFormat.format("Validation for Mule application done ({0}ms)", System.currentTimeMillis() - start));
        } else {
            this.getLog().debug((CharSequence)"Skipping Validation for Mule application");
        }
    }

    public AbstractProjectValidator getProjectValidator() {
        return ProjectValidatorFactory.create((ProjectInformation)this.getProjectInformation(), (AetherMavenClient)this.getAetherMavenClient(), (List)this.sharedLibraries, (Deployment)this.deploymentConfiguration);
    }
}

