/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.api.classloader.model.ApplicationClassLoaderModelAssembler;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.packager.sources.MuleContentGenerator;
import org.mule.tools.api.repository.ArtifactInstaller;
import org.mule.tools.api.repository.RepositoryGenerator;
import org.mule.tools.api.util.PackagerLog;
import org.mule.tools.api.validation.MulePluginsCompatibilityValidator;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.utils.MavenPackagerLog;

@Mojo(name="process-sources", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ProcessSourcesMojo
extends AbstractMuleMojo {
    @Parameter(defaultValue="${skipPluginCompatibilityValidation}")
    protected boolean skipPluginCompatibilityValidation = false;
    protected final MulePluginsCompatibilityValidator mulePluginsCompatibilityValidator = new MulePluginsCompatibilityValidator();

    @Override
    public void doExecute() throws MojoFailureException {
        this.getLog().debug((CharSequence)"Processing sources...");
        if (!this.lightweightPackage || !this.skipPluginCompatibilityValidation) {
            RepositoryGenerator repositoryGenerator = new RepositoryGenerator(this.getProjectInformation().getEffectivePomLocation().toFile(), this.outputDirectory, new ArtifactInstaller((PackagerLog)new MavenPackagerLog(this.getLog())), this.getClassLoaderModelAssembler());
            try {
                ClassLoaderModel classLoaderModel = repositoryGenerator.generate();
                this.mulePluginsCompatibilityValidator.validate(this.getResolver(() -> classLoaderModel.getDependencies().stream().map(Artifact::getArtifactCoordinates).collect(Collectors.toList())).resolve());
                if (!this.lightweightPackage) {
                    ((MuleContentGenerator)this.getContentGenerator()).createApplicationClassLoaderModelJsonFile(classLoaderModel);
                }
            }
            catch (Exception e) {
                String message = String.format("There was an exception while creating the repository of [%s]", this.project.toString());
                throw new MojoFailureException(message, (Throwable)e);
            }
        }
    }

    protected ApplicationClassLoaderModelAssembler getClassLoaderModelAssembler() {
        return new ApplicationClassLoaderModelAssembler(this.getAetherMavenClient());
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_PROCESS_SOURCES_PREVIOUS_RUN_PLACEHOLDER";
    }
}

