/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo.deploy;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.validation.deployment.ProjectDeploymentValidator;
import org.mule.tools.client.standalone.exception.DeploymentException;
import org.mule.tools.maven.mojo.AbstractGenericMojo;
import org.mule.tools.maven.mojo.deploy.logging.MavenDeployerLog;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.AnypointDeployment;
import org.mule.tools.model.anypoint.DeploymentConfigurator;
import org.mule.tools.model.anypoint.MavenResolverMetadata;
import org.mule.tools.utils.DeployerLog;

public abstract class AbstractMuleDeployerMojo
extends AbstractGenericMojo {
    @Component
    protected Settings settings;
    @Component
    protected SettingsDecrypter decrypter;
    @Component
    protected MavenProject mavenProject;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(readonly=true, property="applicationName", defaultValue="${project.artifactId}")
    protected String applicationName;
    @Parameter(readonly=true, property="artifact", defaultValue="${project.artifact.file}")
    protected String artifact;
    protected DeployerLog log;
    protected Deployment deploymentConfiguration;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initMojo();
        this.log = new MavenDeployerLog(this.getLog());
        try {
            this.validateUniqueDeploymentConfiguration();
            new ProjectDeploymentValidator(this.getProjectInformation()).isDeployable();
            this.deploymentConfiguration = this.getDeploymentConfiguration();
        }
        catch (ValidationException | DeploymentException e) {
            throw new MojoExecutionException("Deployment configuration is not valid, ", (Exception)e);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.deploymentConfiguration.getSkip()) && "true".equals(this.deploymentConfiguration.getSkip())) {
            this.getLog().info((CharSequence)("Skipping execution: skip=" + this.deploymentConfiguration.getSkip()));
            return;
        }
        if (this.deploymentConfiguration instanceof AnypointDeployment) {
            this.initializeAnypointDeploymentEnvironment();
        }
        this.getLog().debug((CharSequence)("Executing mojo, skip=" + this.deploymentConfiguration.getSkip()));
        this.doExecute();
    }

    protected Deployment getDeploymentConfiguration() throws DeploymentException {
        List deployments = this.getProjectInformation().getDeployments().stream().filter(Objects::nonNull).collect(Collectors.toList());
        Deployment deploymentConfiguration = (Deployment)deployments.get(0);
        deploymentConfiguration.setDefaultValues(this.mavenProject);
        return deploymentConfiguration;
    }

    private void validateUniqueDeploymentConfiguration() throws ValidationException {
        List deployments = this.getProjectInformation().getDeployments().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (deployments.isEmpty()) {
            throw new ValidationException("No deployment configuration was defined. Aborting.");
        }
        if (deployments.size() > 1) {
            throw new ValidationException("One and only one deployment type can be set up per build. Aborting");
        }
    }

    public MavenResolverMetadata getMetadata() {
        return new MavenResolverMetadata().setFactory(this.artifactFactory).setLocalRepository(this.localRepository).setProject(this.project).setResolver(this.artifactResolver);
    }

    public void initializeAnypointDeploymentEnvironment() throws MojoFailureException, MojoExecutionException {
        DeploymentConfigurator deploymentConfigurator = new DeploymentConfigurator((AnypointDeployment)this.deploymentConfiguration, (DeployerLog)new MavenDeployerLog(this.getLog()));
        deploymentConfigurator.initializeApplication(this.getMetadata());
        deploymentConfigurator.initializeEnvironment(this.settings, this.decrypter);
    }
}

