/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.tools.api.classloader.model.ApplicationClassLoaderModelAssembler;
import org.mule.tools.api.classloader.model.ApplicationGAVModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.NotParameterizedClassLoaderModel;
import org.mule.tools.api.classloader.model.SharedLibraryDependency;
import org.mule.tools.api.classloader.model.resolver.AdditionalPluginDependenciesResolver;
import org.mule.tools.api.classloader.model.resolver.ApplicationDependencyResolver;
import org.mule.tools.api.classloader.model.resolver.ClassloaderModelResolver;
import org.mule.tools.api.classloader.model.resolver.MulePluginClassloaderModelResolver;
import org.mule.tools.api.packager.sources.MuleContentGenerator;
import org.mule.tools.api.repository.ArtifactInstaller;
import org.mule.tools.api.repository.RepositoryGenerator;
import org.mule.tools.api.util.PackagerLog;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.validation.MulePluginsCompatibilityValidator;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.utils.DependencyProject;
import org.mule.tools.maven.utils.MavenPackagerLog;

@Mojo(name="process-sources", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ProcessSourcesMojo
extends AbstractMuleMojo {
    @Deprecated
    @Parameter(defaultValue="${skipPluginCompatibilityValidation}")
    protected boolean skipPluginCompatibilityValidation = false;
    protected final MulePluginsCompatibilityValidator mulePluginsCompatibilityValidator = new MulePluginsCompatibilityValidator();

    @Override
    public void doExecute() throws MojoFailureException {
        boolean isLightWeightUsingLocalRepository;
        this.getLog().debug((CharSequence)"Processing sources...");
        if (this.skipPluginCompatibilityValidation) {
            this.getLog().warn((CharSequence)"Ignoring skipPluginCompatibilityValidation property as it is deprecated. Compatibility between mule-plugin versions is always done.");
        }
        boolean isHeavyWeight = !this.lightweightPackage;
        boolean bl = isLightWeightUsingLocalRepository = this.lightweightPackage && this.useLocalRepository;
        if (isLightWeightUsingLocalRepository || isHeavyWeight) {
            try {
                ApplicationGAVModel appGAV = new ApplicationGAVModel(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
                RepositoryGenerator repositoryGenerator = new RepositoryGenerator(this.session.getCurrentProject().getFile(), this.outputDirectory, new ArtifactInstaller((PackagerLog)new MavenPackagerLog(this.getLog())), this.getClassLoaderModelAssembler(), appGAV);
                ClassLoaderModel classLoaderModel = repositoryGenerator.generate(this.lightweightPackage, this.useLocalRepository);
                for (SharedLibraryDependency sharedLibraryDependency : this.sharedLibraries) {
                    classLoaderModel.getDependencies().stream().filter(dep -> dep.getArtifactCoordinates().getArtifactId().equals(sharedLibraryDependency.getArtifactId()) && dep.getArtifactCoordinates().getGroupId().equals(sharedLibraryDependency.getGroupId())).findFirst().ifPresent(dep -> {
                        if (!this.validateMuleRuntimeSharedLibrary(dep.getArtifactCoordinates().getArtifactId(), dep.getArtifactCoordinates().getGroupId())) {
                            dep.setShared(true);
                        }
                    });
                }
                Project project = this.getProject(classLoaderModel);
                this.mulePluginsCompatibilityValidator.validate(this.getResolver(project).resolve());
                if (isLightWeightUsingLocalRepository) {
                    classLoaderModel = new NotParameterizedClassLoaderModel(classLoaderModel);
                }
                ((MuleContentGenerator)this.getContentGenerator()).createApplicationClassLoaderModelJsonFile(classLoaderModel);
            }
            catch (Exception e) {
                String message = String.format("There was an exception while creating the repository of [%s]", this.project.toString());
                throw new MojoFailureException(message, (Throwable)e);
            }
        }
    }

    protected ApplicationClassLoaderModelAssembler getClassLoaderModelAssembler() {
        AetherMavenClient aetherMavenClient = this.getAetherMavenClient();
        return new ApplicationClassLoaderModelAssembler(new ApplicationDependencyResolver(aetherMavenClient), (ClassloaderModelResolver)new MulePluginClassloaderModelResolver(aetherMavenClient), new AdditionalPluginDependenciesResolver(aetherMavenClient, this.additionalPluginDependencies == null ? new ArrayList() : this.additionalPluginDependencies, new File(this.outputDirectory, "temp")));
    }

    protected final boolean validateMuleRuntimeSharedLibrary(String groupId, String artifactId) {
        if ("org.mule.runtime".equals(groupId) || "com.mulesoft.mule.runtime.modules".equals(groupId)) {
            this.getLog().warn((CharSequence)("Shared library '" + groupId + ":" + artifactId + "' is a Mule Runtime dependency. It will not be shared by the app in order to avoid classloading issues. Please consider removing it, or at least not putting it as a sharedLibrary."));
            return true;
        }
        return false;
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_PROCESS_SOURCES_PREVIOUS_RUN_PLACEHOLDER";
    }

    public Project getProject(final ClassLoaderModel classLoaderModel) {
        final DependencyProject dependencyProject = new DependencyProject(this.project);
        return new Project(){

            public List<ArtifactCoordinates> getDependencies() {
                return classLoaderModel.getDependencies().stream().map(Artifact::getArtifactCoordinates).collect(Collectors.toList());
            }

            public List<BundleDependency> getBundleDependencies() {
                return dependencyProject.getBundleDependencies();
            }
        };
    }
}

