/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.tooling.api.AstGenerator;
import org.mule.tooling.api.ConfigurationException;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.sources.MuleContentGenerator;
import org.mule.tools.api.packager.structure.ProjectStructure;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class CompileMojo
extends AbstractMuleMojo {
    private static final String RUNTIME_AST_VERSION = "4.4.0";
    private static final String MULE_POLICY = "mule-policy";
    private static final String MULE_DOMAIN = "mule-domain";
    private static final String SKIP_AST = "skipAST";

    @Override
    public void doExecute() throws MojoFailureException {
        this.getLog().debug((CharSequence)"Generating mule source code...");
        try {
            ArtifactAst artifact;
            ((MuleContentGenerator)this.getContentGenerator()).createMuleSrcFolderContent();
            String skipAST = System.getProperty(SKIP_AST);
            if (!(skipAST != null && !skipAST.equals("false") || this.project.getPackaging().equals(MULE_POLICY) || this.hasDomain() || (artifact = this.getArtifactAst()) == null)) {
                ((MuleContentGenerator)this.getContentGenerator()).createAstFile(this.serialize(artifact));
            }
        }
        catch (IOException | IllegalArgumentException | ConfigurationException e) {
            throw new MojoFailureException("Fail to compile", e);
        }
    }

    private boolean hasDomain() {
        if (this.project.getDependencies() != null) {
            for (Dependency dependency : this.project.getDependencies()) {
                if (dependency.getClassifier() == null || !dependency.getClassifier().equals(MULE_DOMAIN)) continue;
                return true;
            }
        }
        return false;
    }

    public InputStream serialize(ArtifactAst artifact) {
        return AstGenerator.serialize((ArtifactAst)artifact);
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_COMPILE_PREVIOUS_RUN_PLACEHOLDER";
    }

    public ArtifactAst getArtifactAst() throws IOException, ConfigurationException {
        AstGenerator astGenerator = new AstGenerator((MavenClient)this.getAetherMavenClient(), RUNTIME_AST_VERSION, this.project.getDependencies(), Paths.get(this.project.getBuild().getDirectory(), new String[0]));
        ProjectStructure projectStructure = new ProjectStructure(this.projectBaseFolder.toPath(), false);
        MuleArtifactContentResolver contentResolver = new MuleArtifactContentResolver(new ProjectStructure(this.projectBaseFolder.toPath(), false), this.getProjectInformation().getEffectivePom(), this.getProjectInformation().getProject().getBundleDependencies());
        ArtifactAst artifactAST = astGenerator.generateAST(contentResolver.getConfigs(), projectStructure.getConfigsPath());
        if (artifactAST != null) {
            ArrayList warnings = astGenerator.validateAST(artifactAST);
            for (ValidationResultItem warning : warnings) {
                this.getLog().warn((CharSequence)warning.getMessage());
            }
        }
        return artifactAST;
    }
}

